/*!
[config]
name: Test float acos built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: acos float1
kernel_name: test_1_acos_float
global_size: 5 0 0

arg_out: 0 buffer float[5] 3.141592653589793 1.5707963267948966 0.0 1.447030595701842 nan  tolerance 4 ulp
arg_in: 1 buffer float[5] -1.0 0.0 1.0 0.12345 nan 

[test]
name: acos float2
kernel_name: test_2_acos_float
global_size: 5 0 0

arg_out: 0 buffer float[10] 3.141592653589793 3.141592653589793 1.5707963267948966 1.5707963267948966 0.0 0.0 1.447030595701842 1.447030595701842 nan nan  tolerance 4 ulp
arg_in: 1 buffer float[10] -1.0 -1.0 0.0 0.0 1.0 1.0 0.12345 0.12345 nan nan 

[test]
name: acos float4
kernel_name: test_4_acos_float
global_size: 5 0 0

arg_out: 0 buffer float[20] 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 0.0 0.0 0.0 0.0 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[20] -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.12345 0.12345 0.12345 0.12345 nan nan nan nan 

[test]
name: acos float8
kernel_name: test_8_acos_float
global_size: 5 0 0

arg_out: 0 buffer float[40] 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[40] -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 nan nan nan nan nan nan nan nan 

[test]
name: acos float16
kernel_name: test_16_acos_float
global_size: 5 0 0

arg_out: 0 buffer float[80] 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 3.141592653589793 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 1.5707963267948966 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 1.447030595701842 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 4 ulp
arg_in: 1 buffer float[80] -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 0.12345 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_acos_float(global float* out, global float* in0){
  out[get_global_id(0)] = acos(in0[get_global_id(0)]);
}

kernel void test_2_acos_float(global float* out, global float* in0){
  vstore2(acos(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_acos_float(global float* out, global float* in0){
  vstore4(acos(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_acos_float(global float* out, global float* in0){
  vstore8(acos(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_acos_float(global float* out, global float* in0){
  vstore16(acos(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

