/*!
[config]
name: Test ushort upsample built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: upsample ushort1
kernel_name: test_1_upsample_ushort
global_size: 6 0 0

arg_out: 0 buffer uint[6] 65536 65537 4294967295 0 65535 65543  tolerance 0 
arg_in: 1 buffer ushort[6] 1 1 65535 0 0 1 
arg_in: 2 buffer ushort[6] 0 1 65535 0 65535 7 

[test]
name: upsample ushort2
kernel_name: test_2_upsample_ushort
global_size: 6 0 0

arg_out: 0 buffer uint[12] 65536 65536 65537 65537 4294967295 4294967295 0 0 65535 65535 65543 65543  tolerance 0 
arg_in: 1 buffer ushort[12] 1 1 1 1 65535 65535 0 0 0 0 1 1 
arg_in: 2 buffer ushort[12] 0 0 1 1 65535 65535 0 0 65535 65535 7 7 

[test]
name: upsample ushort4
kernel_name: test_4_upsample_ushort
global_size: 6 0 0

arg_out: 0 buffer uint[24] 65536 65536 65536 65536 65537 65537 65537 65537 4294967295 4294967295 4294967295 4294967295 0 0 0 0 65535 65535 65535 65535 65543 65543 65543 65543  tolerance 0 
arg_in: 1 buffer ushort[24] 1 1 1 1 1 1 1 1 65535 65535 65535 65535 0 0 0 0 0 0 0 0 1 1 1 1 
arg_in: 2 buffer ushort[24] 0 0 0 0 1 1 1 1 65535 65535 65535 65535 0 0 0 0 65535 65535 65535 65535 7 7 7 7 

[test]
name: upsample ushort8
kernel_name: test_8_upsample_ushort
global_size: 6 0 0

arg_out: 0 buffer uint[48] 65536 65536 65536 65536 65536 65536 65536 65536 65537 65537 65537 65537 65537 65537 65537 65537 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65543 65543 65543 65543 65543 65543 65543 65543  tolerance 0 
arg_in: 1 buffer ushort[48] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 
arg_in: 2 buffer ushort[48] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 7 7 7 7 7 7 7 7 

[test]
name: upsample ushort16
kernel_name: test_16_upsample_ushort
global_size: 6 0 0

arg_out: 0 buffer uint[96] 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543  tolerance 0 
arg_in: 1 buffer ushort[96] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer ushort[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 

!*/

kernel void test_1_upsample_ushort(global uint* out, global ushort* in0, global ushort* in1){
  out[get_global_id(0)] = upsample(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_upsample_ushort(global uint* out, global ushort* in0, global ushort* in1){
  vstore2(upsample(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_upsample_ushort(global uint* out, global ushort* in0, global ushort* in1){
  vstore4(upsample(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_upsample_ushort(global uint* out, global ushort* in0, global ushort* in1){
  vstore8(upsample(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_upsample_ushort(global uint* out, global ushort* in0, global ushort* in1){
  vstore16(upsample(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

