/*!
[config]
name: Test ushort rotate built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: rotate ushort1
kernel_name: test_1_rotate_ushort
global_size: 7 0 0

arg_out: 0 buffer ushort[7] 1 8 1 2 1 32768 32768  tolerance 0 
arg_in: 1 buffer ushort[7] 1 1 1 1 1 1 1 
arg_in: 2 buffer ushort[7] 0 3 16 17 160 15 15 

[test]
name: rotate ushort2
kernel_name: test_2_rotate_ushort
global_size: 7 0 0

arg_out: 0 buffer ushort[14] 1 1 8 8 1 1 2 2 1 1 32768 32768 32768 32768  tolerance 0 
arg_in: 1 buffer ushort[14] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer ushort[14] 0 0 3 3 16 16 17 17 160 160 15 15 15 15 

[test]
name: rotate ushort4
kernel_name: test_4_rotate_ushort
global_size: 7 0 0

arg_out: 0 buffer ushort[28] 1 1 1 1 8 8 8 8 1 1 1 1 2 2 2 2 1 1 1 1 32768 32768 32768 32768 32768 32768 32768 32768  tolerance 0 
arg_in: 1 buffer ushort[28] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer ushort[28] 0 0 0 0 3 3 3 3 16 16 16 16 17 17 17 17 160 160 160 160 15 15 15 15 15 15 15 15 

[test]
name: rotate ushort8
kernel_name: test_8_rotate_ushort
global_size: 7 0 0

arg_out: 0 buffer ushort[56] 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768  tolerance 0 
arg_in: 1 buffer ushort[56] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer ushort[56] 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 16 16 16 16 16 16 16 16 17 17 17 17 17 17 17 17 160 160 160 160 160 160 160 160 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 

[test]
name: rotate ushort16
kernel_name: test_16_rotate_ushort
global_size: 7 0 0

arg_out: 0 buffer ushort[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768 32768  tolerance 0 
arg_in: 1 buffer ushort[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer ushort[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 160 160 160 160 160 160 160 160 160 160 160 160 160 160 160 160 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 

!*/

kernel void test_1_rotate_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  out[get_global_id(0)] = rotate(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_rotate_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore2(rotate(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_rotate_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore4(rotate(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_rotate_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore8(rotate(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_rotate_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore16(rotate(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

