/*!
[config]
name: Test ushort popcount built-in on CL 1.1
clc_version_min: 12
dimensions: 1

[test]
name: popcount ushort1
kernel_name: test_1_popcount_ushort
global_size: 5 0 0

arg_out: 0 buffer ushort[5] 1 2 0 16 0  tolerance 0 
arg_in: 1 buffer ushort[5] 1 3 0 65535 0 

[test]
name: popcount ushort2
kernel_name: test_2_popcount_ushort
global_size: 5 0 0

arg_out: 0 buffer ushort[10] 1 1 2 2 0 0 16 16 0 0  tolerance 0 
arg_in: 1 buffer ushort[10] 1 1 3 3 0 0 65535 65535 0 0 

[test]
name: popcount ushort4
kernel_name: test_4_popcount_ushort
global_size: 5 0 0

arg_out: 0 buffer ushort[20] 1 1 1 1 2 2 2 2 0 0 0 0 16 16 16 16 0 0 0 0  tolerance 0 
arg_in: 1 buffer ushort[20] 1 1 1 1 3 3 3 3 0 0 0 0 65535 65535 65535 65535 0 0 0 0 

[test]
name: popcount ushort8
kernel_name: test_8_popcount_ushort
global_size: 5 0 0

arg_out: 0 buffer ushort[40] 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 16 16 16 16 16 16 16 16 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ushort[40] 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 

[test]
name: popcount ushort16
kernel_name: test_16_popcount_ushort
global_size: 5 0 0

arg_out: 0 buffer ushort[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ushort[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

!*/

kernel void test_1_popcount_ushort(global ushort* out, global ushort* in0){
  out[get_global_id(0)] = popcount(in0[get_global_id(0)]);
}

kernel void test_2_popcount_ushort(global ushort* out, global ushort* in0){
  vstore2(popcount(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_popcount_ushort(global ushort* out, global ushort* in0){
  vstore4(popcount(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_popcount_ushort(global ushort* out, global ushort* in0){
  vstore8(popcount(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_popcount_ushort(global ushort* out, global ushort* in0){
  vstore16(popcount(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

