/*!
[config]
name: Test ushort mul_hi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: mul_hi ushort1
kernel_name: test_1_mul_hi_ushort
global_size: 8 0 0

arg_out: 0 buffer ushort[8] 0 0 0 65534 0 0 1 0  tolerance 0 
arg_in: 1 buffer ushort[8] 0 92 65535 65535 0 92 65535 0 
arg_in: 2 buffer ushort[8] 0 2 1 65535 0 1 2 65535 

[test]
name: mul_hi ushort2
kernel_name: test_2_mul_hi_ushort
global_size: 8 0 0

arg_out: 0 buffer ushort[16] 0 0 0 0 0 0 65534 65534 0 0 0 0 1 1 0 0  tolerance 0 
arg_in: 1 buffer ushort[16] 0 0 92 92 65535 65535 65535 65535 0 0 92 92 65535 65535 0 0 
arg_in: 2 buffer ushort[16] 0 0 2 2 1 1 65535 65535 0 0 1 1 2 2 65535 65535 

[test]
name: mul_hi ushort4
kernel_name: test_4_mul_hi_ushort
global_size: 8 0 0

arg_out: 0 buffer ushort[32] 0 0 0 0 0 0 0 0 0 0 0 0 65534 65534 65534 65534 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0  tolerance 0 
arg_in: 1 buffer ushort[32] 0 0 0 0 92 92 92 92 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 92 92 92 92 65535 65535 65535 65535 0 0 0 0 
arg_in: 2 buffer ushort[32] 0 0 0 0 2 2 2 2 1 1 1 1 65535 65535 65535 65535 0 0 0 0 1 1 1 1 2 2 2 2 65535 65535 65535 65535 

[test]
name: mul_hi ushort8
kernel_name: test_8_mul_hi_ushort
global_size: 8 0 0

arg_out: 0 buffer ushort[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65534 65534 65534 65534 65534 65534 65534 65534 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ushort[64] 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ushort[64] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 65535 65535 65535 65535 65535 65535 65535 65535 

[test]
name: mul_hi ushort16
kernel_name: test_16_mul_hi_ushort
global_size: 8 0 0

arg_out: 0 buffer ushort[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ushort[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ushort[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 

!*/

kernel void test_1_mul_hi_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  out[get_global_id(0)] = mul_hi(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_mul_hi_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore2(mul_hi(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_mul_hi_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore4(mul_hi(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_mul_hi_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore8(mul_hi(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_mul_hi_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore16(mul_hi(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

