/*!
[config]
name: Test ushort min built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: min ushort1
kernel_name: test_1_min_ushort
global_size: 11 0 0

arg_out: 0 buffer ushort[11] 2 1 0 4 1 0 65535 0 0 0 65535  tolerance 0 
arg_in: 1 buffer ushort[11] 92 64 2 12 65535 0 65535 0 0 0 65535 
arg_in: 2 buffer ushort[11] 2 1 0 4 1 1 65535 0 65535 0 65535 

[test]
name: min ushort2
kernel_name: test_2_min_ushort
global_size: 11 0 0

arg_out: 0 buffer ushort[22] 2 2 1 1 0 0 4 4 1 1 0 0 65535 65535 0 0 0 0 0 0 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[22] 92 92 64 64 2 2 12 12 65535 65535 0 0 65535 65535 0 0 0 0 0 0 65535 65535 
arg_in: 2 buffer ushort[22] 2 2 1 1 0 0 4 4 1 1 1 1 65535 65535 0 0 65535 65535 0 0 65535 65535 

[test]
name: tss_min ushort2
kernel_name: test_tss_2_min_ushort
global_size: 11 0 0

arg_out: 0 buffer ushort[22] 2 2 1 1 0 0 4 4 1 1 0 0 65535 65535 0 0 0 0 0 0 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[22] 92 92 64 64 2 2 12 12 65535 65535 0 0 65535 65535 0 0 0 0 0 0 65535 65535 
arg_in: 2 buffer ushort[11] 2 1 0 4 1 1 65535 0 65535 0 65535

[test]
name: min ushort4
kernel_name: test_4_min_ushort
global_size: 11 0 0

arg_out: 0 buffer ushort[44] 2 2 2 2 1 1 1 1 0 0 0 0 4 4 4 4 1 1 1 1 0 0 0 0 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[44] 92 92 92 92 64 64 64 64 2 2 2 2 12 12 12 12 65535 65535 65535 65535 0 0 0 0 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 
arg_in: 2 buffer ushort[44] 2 2 2 2 1 1 1 1 0 0 0 0 4 4 4 4 1 1 1 1 1 1 1 1 65535 65535 65535 65535 0 0 0 0 65535 65535 65535 65535 0 0 0 0 65535 65535 65535 65535 

[test]
name: tss_min ushort4
kernel_name: test_tss_4_min_ushort
global_size: 11 0 0

arg_out: 0 buffer ushort[44] 2 2 2 2 1 1 1 1 0 0 0 0 4 4 4 4 1 1 1 1 0 0 0 0 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[44] 92 92 92 92 64 64 64 64 2 2 2 2 12 12 12 12 65535 65535 65535 65535 0 0 0 0 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 
arg_in: 2 buffer ushort[11] 2 1 0 4 1 1 65535 0 65535 0 65535

[test]
name: min ushort8
kernel_name: test_8_min_ushort
global_size: 11 0 0

arg_out: 0 buffer ushort[88] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[88] 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 
arg_in: 2 buffer ushort[88] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 

[test]
name: tss_min ushort8
kernel_name: test_tss_8_min_ushort
global_size: 11 0 0

arg_out: 0 buffer ushort[88] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[88] 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 
arg_in: 2 buffer ushort[11] 2 1 0 4 1 1 65535 0 65535 0 65535

[test]
name: min ushort16
kernel_name: test_16_min_ushort
global_size: 11 0 0

arg_out: 0 buffer ushort[176] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[176] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 
arg_in: 2 buffer ushort[176] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 

[test]
name: tss_min ushort16
kernel_name: test_tss_16_min_ushort
global_size: 11 0 0

arg_out: 0 buffer ushort[176] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[176] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 
arg_in: 2 buffer ushort[11] 2 1 0 4 1 1 65535 0 65535 0 65535

!*/

kernel void test_1_min_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  out[get_global_id(0)] = min(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_min_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore2(min(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_min_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore4(min(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_min_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore8(min(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_min_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore16(min(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_min_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore2(min(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_min_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore4(min(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_min_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore8(min(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_min_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore16(min(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

