/*!
[config]
name: Test ushort max built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: max ushort1
kernel_name: test_1_max_ushort
global_size: 10 0 0

arg_out: 0 buffer ushort[10] 92 2 12 65535 1 65535 0 65535 65535 0  tolerance 0 
arg_in: 1 buffer ushort[10] 92 2 12 65535 0 65535 0 0 65535 0 
arg_in: 2 buffer ushort[10] 2 0 4 1 1 65535 0 65535 0 0 

[test]
name: max ushort2
kernel_name: test_2_max_ushort
global_size: 10 0 0

arg_out: 0 buffer ushort[20] 92 92 2 2 12 12 65535 65535 1 1 65535 65535 0 0 65535 65535 65535 65535 0 0  tolerance 0 
arg_in: 1 buffer ushort[20] 92 92 2 2 12 12 65535 65535 0 0 65535 65535 0 0 0 0 65535 65535 0 0 
arg_in: 2 buffer ushort[20] 2 2 0 0 4 4 1 1 1 1 65535 65535 0 0 65535 65535 0 0 0 0 

[test]
name: tss_max ushort2
kernel_name: test_tss_2_max_ushort
global_size: 10 0 0

arg_out: 0 buffer ushort[20] 92 92 2 2 12 12 65535 65535 1 1 65535 65535 0 0 65535 65535 65535 65535 0 0  tolerance 0 
arg_in: 1 buffer ushort[20] 92 92 2 2 12 12 65535 65535 0 0 65535 65535 0 0 0 0 65535 65535 0 0 
arg_in: 2 buffer ushort[10] 2 0 4 1 1 65535 0 65535 0 0

[test]
name: max ushort4
kernel_name: test_4_max_ushort
global_size: 10 0 0

arg_out: 0 buffer ushort[40] 92 92 92 92 2 2 2 2 12 12 12 12 65535 65535 65535 65535 1 1 1 1 65535 65535 65535 65535 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0  tolerance 0 
arg_in: 1 buffer ushort[40] 92 92 92 92 2 2 2 2 12 12 12 12 65535 65535 65535 65535 0 0 0 0 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 0 0 0 0 
arg_in: 2 buffer ushort[40] 2 2 2 2 0 0 0 0 4 4 4 4 1 1 1 1 1 1 1 1 65535 65535 65535 65535 0 0 0 0 65535 65535 65535 65535 0 0 0 0 0 0 0 0 

[test]
name: tss_max ushort4
kernel_name: test_tss_4_max_ushort
global_size: 10 0 0

arg_out: 0 buffer ushort[40] 92 92 92 92 2 2 2 2 12 12 12 12 65535 65535 65535 65535 1 1 1 1 65535 65535 65535 65535 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0  tolerance 0 
arg_in: 1 buffer ushort[40] 92 92 92 92 2 2 2 2 12 12 12 12 65535 65535 65535 65535 0 0 0 0 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 0 0 0 0 
arg_in: 2 buffer ushort[10] 2 0 4 1 1 65535 0 65535 0 0

[test]
name: max ushort8
kernel_name: test_8_max_ushort
global_size: 10 0 0

arg_out: 0 buffer ushort[80] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ushort[80] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ushort[80] 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

[test]
name: tss_max ushort8
kernel_name: test_tss_8_max_ushort
global_size: 10 0 0

arg_out: 0 buffer ushort[80] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ushort[80] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ushort[10] 2 0 4 1 1 65535 0 65535 0 0

[test]
name: max ushort16
kernel_name: test_16_max_ushort
global_size: 10 0 0

arg_out: 0 buffer ushort[160] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ushort[160] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ushort[160] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

[test]
name: tss_max ushort16
kernel_name: test_tss_16_max_ushort
global_size: 10 0 0

arg_out: 0 buffer ushort[160] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ushort[160] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ushort[10] 2 0 4 1 1 65535 0 65535 0 0

!*/

kernel void test_1_max_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  out[get_global_id(0)] = max(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_max_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore2(max(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_max_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore4(max(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_max_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore8(max(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_max_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore16(max(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_max_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore2(max(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_max_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore4(max(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_max_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore8(max(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_max_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore16(max(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

