/*!
[config]
name: Test ushort hadd built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: hadd ushort1
kernel_name: test_1_hadd_ushort
global_size: 7 0 0

arg_out: 0 buffer ushort[7] 32 0 10 65535 0 32767 32767  tolerance 0 
arg_in: 1 buffer ushort[7] 32 1 12 65535 0 65535 0 
arg_in: 2 buffer ushort[7] 33 0 8 65535 0 0 65535 

[test]
name: hadd ushort2
kernel_name: test_2_hadd_ushort
global_size: 7 0 0

arg_out: 0 buffer ushort[14] 32 32 0 0 10 10 65535 65535 0 0 32767 32767 32767 32767  tolerance 0 
arg_in: 1 buffer ushort[14] 32 32 1 1 12 12 65535 65535 0 0 65535 65535 0 0 
arg_in: 2 buffer ushort[14] 33 33 0 0 8 8 65535 65535 0 0 0 0 65535 65535 

[test]
name: hadd ushort4
kernel_name: test_4_hadd_ushort
global_size: 7 0 0

arg_out: 0 buffer ushort[28] 32 32 32 32 0 0 0 0 10 10 10 10 65535 65535 65535 65535 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767  tolerance 0 
arg_in: 1 buffer ushort[28] 32 32 32 32 1 1 1 1 12 12 12 12 65535 65535 65535 65535 0 0 0 0 65535 65535 65535 65535 0 0 0 0 
arg_in: 2 buffer ushort[28] 33 33 33 33 0 0 0 0 8 8 8 8 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 

[test]
name: hadd ushort8
kernel_name: test_8_hadd_ushort
global_size: 7 0 0

arg_out: 0 buffer ushort[56] 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 10 10 10 10 10 10 10 10 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767  tolerance 0 
arg_in: 1 buffer ushort[56] 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ushort[56] 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 

[test]
name: hadd ushort16
kernel_name: test_16_hadd_ushort
global_size: 7 0 0

arg_out: 0 buffer ushort[112] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767  tolerance 0 
arg_in: 1 buffer ushort[112] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ushort[112] 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 

!*/

kernel void test_1_hadd_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  out[get_global_id(0)] = hadd(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_hadd_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore2(hadd(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_hadd_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore4(hadd(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_hadd_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore8(hadd(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_hadd_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore16(hadd(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

