/*!
[config]
name: Test ushort clamp built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: clamp ushort1
kernel_name: test_1_clamp_ushort
global_size: 3 0 0

arg_out: 0 buffer ushort[3] 64 0 1  tolerance 0 
arg_in: 1 buffer ushort[3] 92 0 64 
arg_in: 2 buffer ushort[3] 0 0 0 
arg_in: 3 buffer ushort[3] 64 0 1 

[test]
name: clamp ushort2
kernel_name: test_2_clamp_ushort
global_size: 3 0 0

arg_out: 0 buffer ushort[6] 64 64 0 0 1 1  tolerance 0 
arg_in: 1 buffer ushort[6] 92 92 0 0 64 64 
arg_in: 2 buffer ushort[6] 0 0 0 0 0 0 
arg_in: 3 buffer ushort[6] 64 64 0 0 1 1 

[test]
name: tss_clamp ushort2
kernel_name: test_tss_2_clamp_ushort
global_size: 3 0 0

arg_out: 0 buffer ushort[6] 64 64 0 0 1 1  tolerance 0 
arg_in: 1 buffer ushort[6] 92 92 0 0 64 64 
arg_in: 2 buffer ushort[3] 0 0 0
arg_in: 3 buffer ushort[3] 64 0 1

[test]
name: clamp ushort4
kernel_name: test_4_clamp_ushort
global_size: 3 0 0

arg_out: 0 buffer ushort[12] 64 64 64 64 0 0 0 0 1 1 1 1  tolerance 0 
arg_in: 1 buffer ushort[12] 92 92 92 92 0 0 0 0 64 64 64 64 
arg_in: 2 buffer ushort[12] 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 3 buffer ushort[12] 64 64 64 64 0 0 0 0 1 1 1 1 

[test]
name: tss_clamp ushort4
kernel_name: test_tss_4_clamp_ushort
global_size: 3 0 0

arg_out: 0 buffer ushort[12] 64 64 64 64 0 0 0 0 1 1 1 1  tolerance 0 
arg_in: 1 buffer ushort[12] 92 92 92 92 0 0 0 0 64 64 64 64 
arg_in: 2 buffer ushort[3] 0 0 0
arg_in: 3 buffer ushort[3] 64 0 1

[test]
name: clamp ushort8
kernel_name: test_8_clamp_ushort
global_size: 3 0 0

arg_out: 0 buffer ushort[24] 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer ushort[24] 92 92 92 92 92 92 92 92 0 0 0 0 0 0 0 0 64 64 64 64 64 64 64 64 
arg_in: 2 buffer ushort[24] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 3 buffer ushort[24] 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 

[test]
name: tss_clamp ushort8
kernel_name: test_tss_8_clamp_ushort
global_size: 3 0 0

arg_out: 0 buffer ushort[24] 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer ushort[24] 92 92 92 92 92 92 92 92 0 0 0 0 0 0 0 0 64 64 64 64 64 64 64 64 
arg_in: 2 buffer ushort[3] 0 0 0
arg_in: 3 buffer ushort[3] 64 0 1

[test]
name: clamp ushort16
kernel_name: test_16_clamp_ushort
global_size: 3 0 0

arg_out: 0 buffer ushort[48] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer ushort[48] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 
arg_in: 2 buffer ushort[48] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 3 buffer ushort[48] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 

[test]
name: tss_clamp ushort16
kernel_name: test_tss_16_clamp_ushort
global_size: 3 0 0

arg_out: 0 buffer ushort[48] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer ushort[48] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 
arg_in: 2 buffer ushort[3] 0 0 0
arg_in: 3 buffer ushort[3] 64 0 1

!*/

kernel void test_1_clamp_ushort(global ushort* out, global ushort* in0, global ushort* in1, global ushort* in2){
  out[get_global_id(0)] = clamp(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_clamp_ushort(global ushort* out, global ushort* in0, global ushort* in1, global ushort* in2){
  vstore2(clamp(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_clamp_ushort(global ushort* out, global ushort* in0, global ushort* in1, global ushort* in2){
  vstore4(clamp(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_clamp_ushort(global ushort* out, global ushort* in0, global ushort* in1, global ushort* in2){
  vstore8(clamp(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_clamp_ushort(global ushort* out, global ushort* in0, global ushort* in1, global ushort* in2){
  vstore16(clamp(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_tss_2_clamp_ushort(global ushort* out, global ushort* in0, global ushort* in1, global ushort* in2){
  vstore2(clamp(vload2(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_clamp_ushort(global ushort* out, global ushort* in0, global ushort* in1, global ushort* in2){
  vstore4(clamp(vload4(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_clamp_ushort(global ushort* out, global ushort* in0, global ushort* in1, global ushort* in2){
  vstore8(clamp(vload8(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_clamp_ushort(global ushort* out, global ushort* in0, global ushort* in1, global ushort* in2){
  vstore16(clamp(vload16(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

