/*!
[config]
name: Test ushort add_sat built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: add_sat ushort1
kernel_name: test_1_add_sat_ushort
global_size: 2 0 0

arg_out: 0 buffer ushort[2] 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[2] 65535 65534 
arg_in: 2 buffer ushort[2] 64 50 

[test]
name: add_sat ushort2
kernel_name: test_2_add_sat_ushort
global_size: 2 0 0

arg_out: 0 buffer ushort[4] 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[4] 65535 65535 65534 65534 
arg_in: 2 buffer ushort[4] 64 64 50 50 

[test]
name: add_sat ushort4
kernel_name: test_4_add_sat_ushort
global_size: 2 0 0

arg_out: 0 buffer ushort[8] 65535 65535 65535 65535 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[8] 65535 65535 65535 65535 65534 65534 65534 65534 
arg_in: 2 buffer ushort[8] 64 64 64 64 50 50 50 50 

[test]
name: add_sat ushort8
kernel_name: test_8_add_sat_ushort
global_size: 2 0 0

arg_out: 0 buffer ushort[16] 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[16] 65535 65535 65535 65535 65535 65535 65535 65535 65534 65534 65534 65534 65534 65534 65534 65534 
arg_in: 2 buffer ushort[16] 64 64 64 64 64 64 64 64 50 50 50 50 50 50 50 50 

[test]
name: add_sat ushort16
kernel_name: test_16_add_sat_ushort
global_size: 2 0 0

arg_out: 0 buffer ushort[32] 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[32] 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 65534 
arg_in: 2 buffer ushort[32] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 50 50 50 50 50 50 50 50 50 50 50 50 50 50 50 50 

!*/

kernel void test_1_add_sat_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  out[get_global_id(0)] = add_sat(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_add_sat_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore2(add_sat(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_add_sat_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore4(add_sat(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_add_sat_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore8(add_sat(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_add_sat_ushort(global ushort* out, global ushort* in0, global ushort* in1){
  vstore16(add_sat(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

