/*!
[config]
name: Test ushort abs built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: abs ushort1
kernel_name: test_1_abs_ushort
global_size: 4 0 0

arg_out: 0 buffer ushort[4] 0 2 0 65535  tolerance 0 
arg_in: 1 buffer ushort[4] 0 2 0 65535 

[test]
name: abs ushort2
kernel_name: test_2_abs_ushort
global_size: 4 0 0

arg_out: 0 buffer ushort[8] 0 0 2 2 0 0 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[8] 0 0 2 2 0 0 65535 65535 

[test]
name: abs ushort4
kernel_name: test_4_abs_ushort
global_size: 4 0 0

arg_out: 0 buffer ushort[16] 0 0 0 0 2 2 2 2 0 0 0 0 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[16] 0 0 0 0 2 2 2 2 0 0 0 0 65535 65535 65535 65535 

[test]
name: abs ushort8
kernel_name: test_8_abs_ushort
global_size: 4 0 0

arg_out: 0 buffer ushort[32] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[32] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 

[test]
name: abs ushort16
kernel_name: test_16_abs_ushort
global_size: 4 0 0

arg_out: 0 buffer ushort[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535  tolerance 0 
arg_in: 1 buffer ushort[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 

!*/

kernel void test_1_abs_ushort(global ushort* out, global ushort* in0){
  out[get_global_id(0)] = abs(in0[get_global_id(0)]);
}

kernel void test_2_abs_ushort(global ushort* out, global ushort* in0){
  vstore2(abs(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_abs_ushort(global ushort* out, global ushort* in0){
  vstore4(abs(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_abs_ushort(global ushort* out, global ushort* in0){
  vstore8(abs(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_abs_ushort(global ushort* out, global ushort* in0){
  vstore16(abs(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

