/*!
[config]
name: Test ulong sub_sat built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: sub_sat ulong1
kernel_name: test_1_sub_sat_ulong
global_size: 7 0 0

arg_out: 0 buffer ulong[7] 1 25 18446744073709551615 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[7] 1 57 18446744073709551615 18446744073709551615 0 0 0 
arg_in: 2 buffer ulong[7] 0 32 0 18446744073709551615 0 18446744073709551615 9223372036854775808 

[test]
name: sub_sat ulong2
kernel_name: test_2_sub_sat_ulong
global_size: 7 0 0

arg_out: 0 buffer ulong[14] 1 1 25 25 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[14] 1 1 57 57 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 
arg_in: 2 buffer ulong[14] 0 0 32 32 0 0 18446744073709551615 18446744073709551615 0 0 18446744073709551615 18446744073709551615 9223372036854775808 9223372036854775808 

[test]
name: sub_sat ulong4
kernel_name: test_4_sub_sat_ulong
global_size: 7 0 0

arg_out: 0 buffer ulong[28] 1 1 1 1 25 25 25 25 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[28] 1 1 1 1 57 57 57 57 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ulong[28] 0 0 0 0 32 32 32 32 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 

[test]
name: sub_sat ulong8
kernel_name: test_8_sub_sat_ulong
global_size: 7 0 0

arg_out: 0 buffer ulong[56] 1 1 1 1 1 1 1 1 25 25 25 25 25 25 25 25 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[56] 1 1 1 1 1 1 1 1 57 57 57 57 57 57 57 57 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ulong[56] 0 0 0 0 0 0 0 0 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 

[test]
name: sub_sat ulong16
kernel_name: test_16_sub_sat_ulong
global_size: 7 0 0

arg_out: 0 buffer ulong[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ulong[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 

!*/

kernel void test_1_sub_sat_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  out[get_global_id(0)] = sub_sat(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_sub_sat_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore2(sub_sat(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_sub_sat_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore4(sub_sat(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_sub_sat_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore8(sub_sat(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_sub_sat_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore16(sub_sat(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

