/*!
[config]
name: Test ulong rotate built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: rotate ulong1
kernel_name: test_1_rotate_ulong
global_size: 7 0 0

arg_out: 0 buffer ulong[7] 1 8 1 2 1 9223372036854775808 9223372036854775808  tolerance 0 
arg_in: 1 buffer ulong[7] 1 1 1 1 1 1 1 
arg_in: 2 buffer ulong[7] 0 3 64 65 640 63 63 

[test]
name: rotate ulong2
kernel_name: test_2_rotate_ulong
global_size: 7 0 0

arg_out: 0 buffer ulong[14] 1 1 8 8 1 1 2 2 1 1 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808  tolerance 0 
arg_in: 1 buffer ulong[14] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer ulong[14] 0 0 3 3 64 64 65 65 640 640 63 63 63 63 

[test]
name: rotate ulong4
kernel_name: test_4_rotate_ulong
global_size: 7 0 0

arg_out: 0 buffer ulong[28] 1 1 1 1 8 8 8 8 1 1 1 1 2 2 2 2 1 1 1 1 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808  tolerance 0 
arg_in: 1 buffer ulong[28] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer ulong[28] 0 0 0 0 3 3 3 3 64 64 64 64 65 65 65 65 640 640 640 640 63 63 63 63 63 63 63 63 

[test]
name: rotate ulong8
kernel_name: test_8_rotate_ulong
global_size: 7 0 0

arg_out: 0 buffer ulong[56] 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808  tolerance 0 
arg_in: 1 buffer ulong[56] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer ulong[56] 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 64 64 64 64 64 64 64 64 65 65 65 65 65 65 65 65 640 640 640 640 640 640 640 640 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 

[test]
name: rotate ulong16
kernel_name: test_16_rotate_ulong
global_size: 7 0 0

arg_out: 0 buffer ulong[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808 9223372036854775808  tolerance 0 
arg_in: 1 buffer ulong[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer ulong[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 65 65 65 65 65 65 65 65 65 65 65 65 65 65 65 65 640 640 640 640 640 640 640 640 640 640 640 640 640 640 640 640 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 

!*/

kernel void test_1_rotate_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  out[get_global_id(0)] = rotate(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_rotate_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore2(rotate(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_rotate_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore4(rotate(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_rotate_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore8(rotate(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_rotate_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore16(rotate(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

