/*!
[config]
name: Test ulong popcount built-in on CL 1.1
clc_version_min: 12
dimensions: 1

[test]
name: popcount ulong1
kernel_name: test_1_popcount_ulong
global_size: 5 0 0

arg_out: 0 buffer ulong[5] 1 2 0 64 0  tolerance 0 
arg_in: 1 buffer ulong[5] 1 3 0 18446744073709551615 0 

[test]
name: popcount ulong2
kernel_name: test_2_popcount_ulong
global_size: 5 0 0

arg_out: 0 buffer ulong[10] 1 1 2 2 0 0 64 64 0 0  tolerance 0 
arg_in: 1 buffer ulong[10] 1 1 3 3 0 0 18446744073709551615 18446744073709551615 0 0 

[test]
name: popcount ulong4
kernel_name: test_4_popcount_ulong
global_size: 5 0 0

arg_out: 0 buffer ulong[20] 1 1 1 1 2 2 2 2 0 0 0 0 64 64 64 64 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[20] 1 1 1 1 3 3 3 3 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 

[test]
name: popcount ulong8
kernel_name: test_8_popcount_ulong
global_size: 5 0 0

arg_out: 0 buffer ulong[40] 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[40] 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 

[test]
name: popcount ulong16
kernel_name: test_16_popcount_ulong
global_size: 5 0 0

arg_out: 0 buffer ulong[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

!*/

kernel void test_1_popcount_ulong(global ulong* out, global ulong* in0){
  out[get_global_id(0)] = popcount(in0[get_global_id(0)]);
}

kernel void test_2_popcount_ulong(global ulong* out, global ulong* in0){
  vstore2(popcount(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_popcount_ulong(global ulong* out, global ulong* in0){
  vstore4(popcount(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_popcount_ulong(global ulong* out, global ulong* in0){
  vstore8(popcount(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_popcount_ulong(global ulong* out, global ulong* in0){
  vstore16(popcount(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

