/*!
[config]
name: Test ulong mul_hi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: mul_hi ulong1
kernel_name: test_1_mul_hi_ulong
global_size: 8 0 0

arg_out: 0 buffer ulong[8] 0 0 0 18446744073709551614 0 0 1 0  tolerance 0 
arg_in: 1 buffer ulong[8] 0 92 18446744073709551615 18446744073709551615 0 92 18446744073709551615 0 
arg_in: 2 buffer ulong[8] 0 2 1 18446744073709551615 0 1 2 18446744073709551615 

[test]
name: mul_hi ulong2
kernel_name: test_2_mul_hi_ulong
global_size: 8 0 0

arg_out: 0 buffer ulong[16] 0 0 0 0 0 0 18446744073709551614 18446744073709551614 0 0 0 0 1 1 0 0  tolerance 0 
arg_in: 1 buffer ulong[16] 0 0 92 92 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 92 92 18446744073709551615 18446744073709551615 0 0 
arg_in: 2 buffer ulong[16] 0 0 2 2 1 1 18446744073709551615 18446744073709551615 0 0 1 1 2 2 18446744073709551615 18446744073709551615 

[test]
name: mul_hi ulong4
kernel_name: test_4_mul_hi_ulong
global_size: 8 0 0

arg_out: 0 buffer ulong[32] 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[32] 0 0 0 0 92 92 92 92 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 92 92 92 92 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 
arg_in: 2 buffer ulong[32] 0 0 0 0 2 2 2 2 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 1 1 1 1 2 2 2 2 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 

[test]
name: mul_hi ulong8
kernel_name: test_8_mul_hi_ulong
global_size: 8 0 0

arg_out: 0 buffer ulong[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[64] 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ulong[64] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 

[test]
name: mul_hi ulong16
kernel_name: test_16_mul_hi_ulong
global_size: 8 0 0

arg_out: 0 buffer ulong[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 18446744073709551614 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ulong[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 

!*/

kernel void test_1_mul_hi_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  out[get_global_id(0)] = mul_hi(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_mul_hi_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore2(mul_hi(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_mul_hi_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore4(mul_hi(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_mul_hi_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore8(mul_hi(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_mul_hi_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore16(mul_hi(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

