/*!
[config]
name: Test ulong min built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: min ulong1
kernel_name: test_1_min_ulong
global_size: 11 0 0

arg_out: 0 buffer ulong[11] 2 1 0 4 1 0 18446744073709551615 0 0 0 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[11] 92 64 2 12 18446744073709551615 0 18446744073709551615 0 0 0 18446744073709551615 
arg_in: 2 buffer ulong[11] 2 1 0 4 1 1 18446744073709551615 0 18446744073709551615 0 18446744073709551615 

[test]
name: min ulong2
kernel_name: test_2_min_ulong
global_size: 11 0 0

arg_out: 0 buffer ulong[22] 2 2 1 1 0 0 4 4 1 1 0 0 18446744073709551615 18446744073709551615 0 0 0 0 0 0 18446744073709551615 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[22] 92 92 64 64 2 2 12 12 18446744073709551615 18446744073709551615 0 0 18446744073709551615 18446744073709551615 0 0 0 0 0 0 18446744073709551615 18446744073709551615 
arg_in: 2 buffer ulong[22] 2 2 1 1 0 0 4 4 1 1 1 1 18446744073709551615 18446744073709551615 0 0 18446744073709551615 18446744073709551615 0 0 18446744073709551615 18446744073709551615 

[test]
name: tss_min ulong2
kernel_name: test_tss_2_min_ulong
global_size: 11 0 0

arg_out: 0 buffer ulong[22] 2 2 1 1 0 0 4 4 1 1 0 0 18446744073709551615 18446744073709551615 0 0 0 0 0 0 18446744073709551615 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[22] 92 92 64 64 2 2 12 12 18446744073709551615 18446744073709551615 0 0 18446744073709551615 18446744073709551615 0 0 0 0 0 0 18446744073709551615 18446744073709551615 
arg_in: 2 buffer ulong[11] 2 1 0 4 1 1 18446744073709551615 0 18446744073709551615 0 18446744073709551615

[test]
name: min ulong4
kernel_name: test_4_min_ulong
global_size: 11 0 0

arg_out: 0 buffer ulong[44] 2 2 2 2 1 1 1 1 0 0 0 0 4 4 4 4 1 1 1 1 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[44] 92 92 92 92 64 64 64 64 2 2 2 2 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 
arg_in: 2 buffer ulong[44] 2 2 2 2 1 1 1 1 0 0 0 0 4 4 4 4 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 

[test]
name: tss_min ulong4
kernel_name: test_tss_4_min_ulong
global_size: 11 0 0

arg_out: 0 buffer ulong[44] 2 2 2 2 1 1 1 1 0 0 0 0 4 4 4 4 1 1 1 1 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[44] 92 92 92 92 64 64 64 64 2 2 2 2 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 
arg_in: 2 buffer ulong[11] 2 1 0 4 1 1 18446744073709551615 0 18446744073709551615 0 18446744073709551615

[test]
name: min ulong8
kernel_name: test_8_min_ulong
global_size: 11 0 0

arg_out: 0 buffer ulong[88] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[88] 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 
arg_in: 2 buffer ulong[88] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 

[test]
name: tss_min ulong8
kernel_name: test_tss_8_min_ulong
global_size: 11 0 0

arg_out: 0 buffer ulong[88] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[88] 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 
arg_in: 2 buffer ulong[11] 2 1 0 4 1 1 18446744073709551615 0 18446744073709551615 0 18446744073709551615

[test]
name: min ulong16
kernel_name: test_16_min_ulong
global_size: 11 0 0

arg_out: 0 buffer ulong[176] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[176] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 
arg_in: 2 buffer ulong[176] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 

[test]
name: tss_min ulong16
kernel_name: test_tss_16_min_ulong
global_size: 11 0 0

arg_out: 0 buffer ulong[176] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[176] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 
arg_in: 2 buffer ulong[11] 2 1 0 4 1 1 18446744073709551615 0 18446744073709551615 0 18446744073709551615

!*/

kernel void test_1_min_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  out[get_global_id(0)] = min(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_min_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore2(min(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_min_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore4(min(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_min_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore8(min(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_min_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore16(min(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_min_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore2(min(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_min_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore4(min(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_min_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore8(min(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_min_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore16(min(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

