/*!
[config]
name: Test ulong max built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: max ulong1
kernel_name: test_1_max_ulong
global_size: 10 0 0

arg_out: 0 buffer ulong[10] 92 2 12 18446744073709551615 1 18446744073709551615 0 18446744073709551615 18446744073709551615 0  tolerance 0 
arg_in: 1 buffer ulong[10] 92 2 12 18446744073709551615 0 18446744073709551615 0 0 18446744073709551615 0 
arg_in: 2 buffer ulong[10] 2 0 4 1 1 18446744073709551615 0 18446744073709551615 0 0 

[test]
name: max ulong2
kernel_name: test_2_max_ulong
global_size: 10 0 0

arg_out: 0 buffer ulong[20] 92 92 2 2 12 12 18446744073709551615 18446744073709551615 1 1 18446744073709551615 18446744073709551615 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0  tolerance 0 
arg_in: 1 buffer ulong[20] 92 92 2 2 12 12 18446744073709551615 18446744073709551615 0 0 18446744073709551615 18446744073709551615 0 0 0 0 18446744073709551615 18446744073709551615 0 0 
arg_in: 2 buffer ulong[20] 2 2 0 0 4 4 1 1 1 1 18446744073709551615 18446744073709551615 0 0 18446744073709551615 18446744073709551615 0 0 0 0 

[test]
name: tss_max ulong2
kernel_name: test_tss_2_max_ulong
global_size: 10 0 0

arg_out: 0 buffer ulong[20] 92 92 2 2 12 12 18446744073709551615 18446744073709551615 1 1 18446744073709551615 18446744073709551615 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0  tolerance 0 
arg_in: 1 buffer ulong[20] 92 92 2 2 12 12 18446744073709551615 18446744073709551615 0 0 18446744073709551615 18446744073709551615 0 0 0 0 18446744073709551615 18446744073709551615 0 0 
arg_in: 2 buffer ulong[10] 2 0 4 1 1 18446744073709551615 0 18446744073709551615 0 0

[test]
name: max ulong4
kernel_name: test_4_max_ulong
global_size: 10 0 0

arg_out: 0 buffer ulong[40] 92 92 92 92 2 2 2 2 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[40] 92 92 92 92 2 2 2 2 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 
arg_in: 2 buffer ulong[40] 2 2 2 2 0 0 0 0 4 4 4 4 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 

[test]
name: tss_max ulong4
kernel_name: test_tss_4_max_ulong
global_size: 10 0 0

arg_out: 0 buffer ulong[40] 92 92 92 92 2 2 2 2 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[40] 92 92 92 92 2 2 2 2 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 
arg_in: 2 buffer ulong[10] 2 0 4 1 1 18446744073709551615 0 18446744073709551615 0 0

[test]
name: max ulong8
kernel_name: test_8_max_ulong
global_size: 10 0 0

arg_out: 0 buffer ulong[80] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[80] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ulong[80] 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

[test]
name: tss_max ulong8
kernel_name: test_tss_8_max_ulong
global_size: 10 0 0

arg_out: 0 buffer ulong[80] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[80] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ulong[10] 2 0 4 1 1 18446744073709551615 0 18446744073709551615 0 0

[test]
name: max ulong16
kernel_name: test_16_max_ulong
global_size: 10 0 0

arg_out: 0 buffer ulong[160] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[160] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ulong[160] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

[test]
name: tss_max ulong16
kernel_name: test_tss_16_max_ulong
global_size: 10 0 0

arg_out: 0 buffer ulong[160] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer ulong[160] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer ulong[10] 2 0 4 1 1 18446744073709551615 0 18446744073709551615 0 0

!*/

kernel void test_1_max_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  out[get_global_id(0)] = max(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_max_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore2(max(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_max_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore4(max(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_max_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore8(max(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_max_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore16(max(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_max_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore2(max(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_max_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore4(max(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_max_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore8(max(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_max_ulong(global ulong* out, global ulong* in0, global ulong* in1){
  vstore16(max(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

