/*!
[config]
name: Test ulong clz built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: clz ulong1
kernel_name: test_1_clz_ulong
global_size: 5 0 0

arg_out: 0 buffer ulong[5] 63 57 64 0 64  tolerance 0 
arg_in: 1 buffer ulong[5] 1 64 0 18446744073709551615 0 

[test]
name: clz ulong2
kernel_name: test_2_clz_ulong
global_size: 5 0 0

arg_out: 0 buffer ulong[10] 63 63 57 57 64 64 0 0 64 64  tolerance 0 
arg_in: 1 buffer ulong[10] 1 1 64 64 0 0 18446744073709551615 18446744073709551615 0 0 

[test]
name: clz ulong4
kernel_name: test_4_clz_ulong
global_size: 5 0 0

arg_out: 0 buffer ulong[20] 63 63 63 63 57 57 57 57 64 64 64 64 0 0 0 0 64 64 64 64  tolerance 0 
arg_in: 1 buffer ulong[20] 1 1 1 1 64 64 64 64 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 

[test]
name: clz ulong8
kernel_name: test_8_clz_ulong
global_size: 5 0 0

arg_out: 0 buffer ulong[40] 63 63 63 63 63 63 63 63 57 57 57 57 57 57 57 57 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 64 64 64 64 64 64 64 64  tolerance 0 
arg_in: 1 buffer ulong[40] 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 

[test]
name: clz ulong16
kernel_name: test_16_clz_ulong
global_size: 5 0 0

arg_out: 0 buffer ulong[80] 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64  tolerance 0 
arg_in: 1 buffer ulong[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

!*/

kernel void test_1_clz_ulong(global ulong* out, global ulong* in0){
  out[get_global_id(0)] = clz(in0[get_global_id(0)]);
}

kernel void test_2_clz_ulong(global ulong* out, global ulong* in0){
  vstore2(clz(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_clz_ulong(global ulong* out, global ulong* in0){
  vstore4(clz(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_clz_ulong(global ulong* out, global ulong* in0){
  vstore8(clz(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_clz_ulong(global ulong* out, global ulong* in0){
  vstore16(clz(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

