/*!
[config]
name: Test ulong abs built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: abs ulong1
kernel_name: test_1_abs_ulong
global_size: 4 0 0

arg_out: 0 buffer ulong[4] 0 2 0 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[4] 0 2 0 18446744073709551615 

[test]
name: abs ulong2
kernel_name: test_2_abs_ulong
global_size: 4 0 0

arg_out: 0 buffer ulong[8] 0 0 2 2 0 0 18446744073709551615 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[8] 0 0 2 2 0 0 18446744073709551615 18446744073709551615 

[test]
name: abs ulong4
kernel_name: test_4_abs_ulong
global_size: 4 0 0

arg_out: 0 buffer ulong[16] 0 0 0 0 2 2 2 2 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[16] 0 0 0 0 2 2 2 2 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 

[test]
name: abs ulong8
kernel_name: test_8_abs_ulong
global_size: 4 0 0

arg_out: 0 buffer ulong[32] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[32] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 

[test]
name: abs ulong16
kernel_name: test_16_abs_ulong
global_size: 4 0 0

arg_out: 0 buffer ulong[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615  tolerance 0 
arg_in: 1 buffer ulong[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 

!*/

kernel void test_1_abs_ulong(global ulong* out, global ulong* in0){
  out[get_global_id(0)] = abs(in0[get_global_id(0)]);
}

kernel void test_2_abs_ulong(global ulong* out, global ulong* in0){
  vstore2(abs(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_abs_ulong(global ulong* out, global ulong* in0){
  vstore4(abs(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_abs_ulong(global ulong* out, global ulong* in0){
  vstore8(abs(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_abs_ulong(global ulong* out, global ulong* in0){
  vstore16(abs(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

