/*!
[config]
name: Test uint upsample built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: upsample uint1
kernel_name: test_1_upsample_uint
global_size: 6 0 0

arg_out: 0 buffer ulong[6] 4294967296 4294967297 18446744073709551615 0 4294967295 4294967303  tolerance 0 
arg_in: 1 buffer uint[6] 1 1 4294967295 0 0 1 
arg_in: 2 buffer uint[6] 0 1 4294967295 0 4294967295 7 

[test]
name: upsample uint2
kernel_name: test_2_upsample_uint
global_size: 6 0 0

arg_out: 0 buffer ulong[12] 4294967296 4294967296 4294967297 4294967297 18446744073709551615 18446744073709551615 0 0 4294967295 4294967295 4294967303 4294967303  tolerance 0 
arg_in: 1 buffer uint[12] 1 1 1 1 4294967295 4294967295 0 0 0 0 1 1 
arg_in: 2 buffer uint[12] 0 0 1 1 4294967295 4294967295 0 0 4294967295 4294967295 7 7 

[test]
name: upsample uint4
kernel_name: test_4_upsample_uint
global_size: 6 0 0

arg_out: 0 buffer ulong[24] 4294967296 4294967296 4294967296 4294967296 4294967297 4294967297 4294967297 4294967297 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967303 4294967303 4294967303 4294967303  tolerance 0 
arg_in: 1 buffer uint[24] 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 1 1 1 1 
arg_in: 2 buffer uint[24] 0 0 0 0 1 1 1 1 4294967295 4294967295 4294967295 4294967295 0 0 0 0 4294967295 4294967295 4294967295 4294967295 7 7 7 7 

[test]
name: upsample uint8
kernel_name: test_8_upsample_uint
global_size: 6 0 0

arg_out: 0 buffer ulong[48] 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303  tolerance 0 
arg_in: 1 buffer uint[48] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 
arg_in: 2 buffer uint[48] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 7 7 7 7 7 7 7 7 

[test]
name: upsample uint16
kernel_name: test_16_upsample_uint
global_size: 6 0 0

arg_out: 0 buffer ulong[96] 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967296 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 4294967297 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 18446744073709551615 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303 4294967303  tolerance 0 
arg_in: 1 buffer uint[96] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer uint[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 

!*/

kernel void test_1_upsample_uint(global ulong* out, global uint* in0, global uint* in1){
  out[get_global_id(0)] = upsample(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_upsample_uint(global ulong* out, global uint* in0, global uint* in1){
  vstore2(upsample(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_upsample_uint(global ulong* out, global uint* in0, global uint* in1){
  vstore4(upsample(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_upsample_uint(global ulong* out, global uint* in0, global uint* in1){
  vstore8(upsample(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_upsample_uint(global ulong* out, global uint* in0, global uint* in1){
  vstore16(upsample(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

