/*!
[config]
name: Test uint sub_sat built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: sub_sat uint1
kernel_name: test_1_sub_sat_uint
global_size: 7 0 0

arg_out: 0 buffer uint[7] 1 25 4294967295 0 0 0 0  tolerance 0 
arg_in: 1 buffer uint[7] 1 57 4294967295 4294967295 0 0 0 
arg_in: 2 buffer uint[7] 0 32 0 4294967295 0 4294967295 2147483648 

[test]
name: sub_sat uint2
kernel_name: test_2_sub_sat_uint
global_size: 7 0 0

arg_out: 0 buffer uint[14] 1 1 25 25 4294967295 4294967295 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uint[14] 1 1 57 57 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 
arg_in: 2 buffer uint[14] 0 0 32 32 0 0 4294967295 4294967295 0 0 4294967295 4294967295 2147483648 2147483648 

[test]
name: sub_sat uint4
kernel_name: test_4_sub_sat_uint
global_size: 7 0 0

arg_out: 0 buffer uint[28] 1 1 1 1 25 25 25 25 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uint[28] 1 1 1 1 57 57 57 57 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uint[28] 0 0 0 0 32 32 32 32 0 0 0 0 4294967295 4294967295 4294967295 4294967295 0 0 0 0 4294967295 4294967295 4294967295 4294967295 2147483648 2147483648 2147483648 2147483648 

[test]
name: sub_sat uint8
kernel_name: test_8_sub_sat_uint
global_size: 7 0 0

arg_out: 0 buffer uint[56] 1 1 1 1 1 1 1 1 25 25 25 25 25 25 25 25 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uint[56] 1 1 1 1 1 1 1 1 57 57 57 57 57 57 57 57 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uint[56] 0 0 0 0 0 0 0 0 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 

[test]
name: sub_sat uint16
kernel_name: test_16_sub_sat_uint
global_size: 7 0 0

arg_out: 0 buffer uint[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uint[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uint[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 

!*/

kernel void test_1_sub_sat_uint(global uint* out, global uint* in0, global uint* in1){
  out[get_global_id(0)] = sub_sat(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_sub_sat_uint(global uint* out, global uint* in0, global uint* in1){
  vstore2(sub_sat(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_sub_sat_uint(global uint* out, global uint* in0, global uint* in1){
  vstore4(sub_sat(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_sub_sat_uint(global uint* out, global uint* in0, global uint* in1){
  vstore8(sub_sat(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_sub_sat_uint(global uint* out, global uint* in0, global uint* in1){
  vstore16(sub_sat(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

