/*!
[config]
name: Test uint rotate built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: rotate uint1
kernel_name: test_1_rotate_uint
global_size: 7 0 0

arg_out: 0 buffer uint[7] 1 8 1 2 1 2147483648 2147483648  tolerance 0 
arg_in: 1 buffer uint[7] 1 1 1 1 1 1 1 
arg_in: 2 buffer uint[7] 0 3 32 33 320 31 31 

[test]
name: rotate uint2
kernel_name: test_2_rotate_uint
global_size: 7 0 0

arg_out: 0 buffer uint[14] 1 1 8 8 1 1 2 2 1 1 2147483648 2147483648 2147483648 2147483648  tolerance 0 
arg_in: 1 buffer uint[14] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer uint[14] 0 0 3 3 32 32 33 33 320 320 31 31 31 31 

[test]
name: rotate uint4
kernel_name: test_4_rotate_uint
global_size: 7 0 0

arg_out: 0 buffer uint[28] 1 1 1 1 8 8 8 8 1 1 1 1 2 2 2 2 1 1 1 1 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648  tolerance 0 
arg_in: 1 buffer uint[28] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer uint[28] 0 0 0 0 3 3 3 3 32 32 32 32 33 33 33 33 320 320 320 320 31 31 31 31 31 31 31 31 

[test]
name: rotate uint8
kernel_name: test_8_rotate_uint
global_size: 7 0 0

arg_out: 0 buffer uint[56] 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648  tolerance 0 
arg_in: 1 buffer uint[56] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer uint[56] 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 32 32 32 32 32 32 32 32 33 33 33 33 33 33 33 33 320 320 320 320 320 320 320 320 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 

[test]
name: rotate uint16
kernel_name: test_16_rotate_uint
global_size: 7 0 0

arg_out: 0 buffer uint[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648 2147483648  tolerance 0 
arg_in: 1 buffer uint[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer uint[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 320 320 320 320 320 320 320 320 320 320 320 320 320 320 320 320 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 

!*/

kernel void test_1_rotate_uint(global uint* out, global uint* in0, global uint* in1){
  out[get_global_id(0)] = rotate(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_rotate_uint(global uint* out, global uint* in0, global uint* in1){
  vstore2(rotate(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_rotate_uint(global uint* out, global uint* in0, global uint* in1){
  vstore4(rotate(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_rotate_uint(global uint* out, global uint* in0, global uint* in1){
  vstore8(rotate(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_rotate_uint(global uint* out, global uint* in0, global uint* in1){
  vstore16(rotate(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

