/*!
[config]
name: Test uint popcount built-in on CL 1.1
clc_version_min: 12
dimensions: 1

[test]
name: popcount uint1
kernel_name: test_1_popcount_uint
global_size: 5 0 0

arg_out: 0 buffer uint[5] 1 2 0 32 0  tolerance 0 
arg_in: 1 buffer uint[5] 1 3 0 4294967295 0 

[test]
name: popcount uint2
kernel_name: test_2_popcount_uint
global_size: 5 0 0

arg_out: 0 buffer uint[10] 1 1 2 2 0 0 32 32 0 0  tolerance 0 
arg_in: 1 buffer uint[10] 1 1 3 3 0 0 4294967295 4294967295 0 0 

[test]
name: popcount uint4
kernel_name: test_4_popcount_uint
global_size: 5 0 0

arg_out: 0 buffer uint[20] 1 1 1 1 2 2 2 2 0 0 0 0 32 32 32 32 0 0 0 0  tolerance 0 
arg_in: 1 buffer uint[20] 1 1 1 1 3 3 3 3 0 0 0 0 4294967295 4294967295 4294967295 4294967295 0 0 0 0 

[test]
name: popcount uint8
kernel_name: test_8_popcount_uint
global_size: 5 0 0

arg_out: 0 buffer uint[40] 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uint[40] 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 

[test]
name: popcount uint16
kernel_name: test_16_popcount_uint
global_size: 5 0 0

arg_out: 0 buffer uint[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uint[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

!*/

kernel void test_1_popcount_uint(global uint* out, global uint* in0){
  out[get_global_id(0)] = popcount(in0[get_global_id(0)]);
}

kernel void test_2_popcount_uint(global uint* out, global uint* in0){
  vstore2(popcount(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_popcount_uint(global uint* out, global uint* in0){
  vstore4(popcount(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_popcount_uint(global uint* out, global uint* in0){
  vstore8(popcount(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_popcount_uint(global uint* out, global uint* in0){
  vstore16(popcount(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

