/*!
[config]
name: Test uint mul_hi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: mul_hi uint1
kernel_name: test_1_mul_hi_uint
global_size: 8 0 0

arg_out: 0 buffer uint[8] 0 0 0 4294967294 0 0 1 0  tolerance 0 
arg_in: 1 buffer uint[8] 0 92 4294967295 4294967295 0 92 4294967295 0 
arg_in: 2 buffer uint[8] 0 2 1 4294967295 0 1 2 4294967295 

[test]
name: mul_hi uint2
kernel_name: test_2_mul_hi_uint
global_size: 8 0 0

arg_out: 0 buffer uint[16] 0 0 0 0 0 0 4294967294 4294967294 0 0 0 0 1 1 0 0  tolerance 0 
arg_in: 1 buffer uint[16] 0 0 92 92 4294967295 4294967295 4294967295 4294967295 0 0 92 92 4294967295 4294967295 0 0 
arg_in: 2 buffer uint[16] 0 0 2 2 1 1 4294967295 4294967295 0 0 1 1 2 2 4294967295 4294967295 

[test]
name: mul_hi uint4
kernel_name: test_4_mul_hi_uint
global_size: 8 0 0

arg_out: 0 buffer uint[32] 0 0 0 0 0 0 0 0 0 0 0 0 4294967294 4294967294 4294967294 4294967294 0 0 0 0 0 0 0 0 1 1 1 1 0 0 0 0  tolerance 0 
arg_in: 1 buffer uint[32] 0 0 0 0 92 92 92 92 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 92 92 92 92 4294967295 4294967295 4294967295 4294967295 0 0 0 0 
arg_in: 2 buffer uint[32] 0 0 0 0 2 2 2 2 1 1 1 1 4294967295 4294967295 4294967295 4294967295 0 0 0 0 1 1 1 1 2 2 2 2 4294967295 4294967295 4294967295 4294967295 

[test]
name: mul_hi uint8
kernel_name: test_8_mul_hi_uint
global_size: 8 0 0

arg_out: 0 buffer uint[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uint[64] 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uint[64] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 

[test]
name: mul_hi uint16
kernel_name: test_16_mul_hi_uint
global_size: 8 0 0

arg_out: 0 buffer uint[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 4294967294 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uint[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uint[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 

!*/

kernel void test_1_mul_hi_uint(global uint* out, global uint* in0, global uint* in1){
  out[get_global_id(0)] = mul_hi(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_mul_hi_uint(global uint* out, global uint* in0, global uint* in1){
  vstore2(mul_hi(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_mul_hi_uint(global uint* out, global uint* in0, global uint* in1){
  vstore4(mul_hi(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_mul_hi_uint(global uint* out, global uint* in0, global uint* in1){
  vstore8(mul_hi(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_mul_hi_uint(global uint* out, global uint* in0, global uint* in1){
  vstore16(mul_hi(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

