/*!
[config]
name: Test uint min built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: min uint1
kernel_name: test_1_min_uint
global_size: 11 0 0

arg_out: 0 buffer uint[11] 2 1 0 4 1 0 4294967295 0 0 0 4294967295  tolerance 0 
arg_in: 1 buffer uint[11] 92 64 2 12 4294967295 0 4294967295 0 0 0 4294967295 
arg_in: 2 buffer uint[11] 2 1 0 4 1 1 4294967295 0 4294967295 0 4294967295 

[test]
name: min uint2
kernel_name: test_2_min_uint
global_size: 11 0 0

arg_out: 0 buffer uint[22] 2 2 1 1 0 0 4 4 1 1 0 0 4294967295 4294967295 0 0 0 0 0 0 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[22] 92 92 64 64 2 2 12 12 4294967295 4294967295 0 0 4294967295 4294967295 0 0 0 0 0 0 4294967295 4294967295 
arg_in: 2 buffer uint[22] 2 2 1 1 0 0 4 4 1 1 1 1 4294967295 4294967295 0 0 4294967295 4294967295 0 0 4294967295 4294967295 

[test]
name: tss_min uint2
kernel_name: test_tss_2_min_uint
global_size: 11 0 0

arg_out: 0 buffer uint[22] 2 2 1 1 0 0 4 4 1 1 0 0 4294967295 4294967295 0 0 0 0 0 0 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[22] 92 92 64 64 2 2 12 12 4294967295 4294967295 0 0 4294967295 4294967295 0 0 0 0 0 0 4294967295 4294967295 
arg_in: 2 buffer uint[11] 2 1 0 4 1 1 4294967295 0 4294967295 0 4294967295

[test]
name: min uint4
kernel_name: test_4_min_uint
global_size: 11 0 0

arg_out: 0 buffer uint[44] 2 2 2 2 1 1 1 1 0 0 0 0 4 4 4 4 1 1 1 1 0 0 0 0 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[44] 92 92 92 92 64 64 64 64 2 2 2 2 12 12 12 12 4294967295 4294967295 4294967295 4294967295 0 0 0 0 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 
arg_in: 2 buffer uint[44] 2 2 2 2 1 1 1 1 0 0 0 0 4 4 4 4 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 0 0 0 0 4294967295 4294967295 4294967295 4294967295 0 0 0 0 4294967295 4294967295 4294967295 4294967295 

[test]
name: tss_min uint4
kernel_name: test_tss_4_min_uint
global_size: 11 0 0

arg_out: 0 buffer uint[44] 2 2 2 2 1 1 1 1 0 0 0 0 4 4 4 4 1 1 1 1 0 0 0 0 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[44] 92 92 92 92 64 64 64 64 2 2 2 2 12 12 12 12 4294967295 4294967295 4294967295 4294967295 0 0 0 0 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 
arg_in: 2 buffer uint[11] 2 1 0 4 1 1 4294967295 0 4294967295 0 4294967295

[test]
name: min uint8
kernel_name: test_8_min_uint
global_size: 11 0 0

arg_out: 0 buffer uint[88] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[88] 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 
arg_in: 2 buffer uint[88] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 

[test]
name: tss_min uint8
kernel_name: test_tss_8_min_uint
global_size: 11 0 0

arg_out: 0 buffer uint[88] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[88] 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 
arg_in: 2 buffer uint[11] 2 1 0 4 1 1 4294967295 0 4294967295 0 4294967295

[test]
name: min uint16
kernel_name: test_16_min_uint
global_size: 11 0 0

arg_out: 0 buffer uint[176] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[176] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 
arg_in: 2 buffer uint[176] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 

[test]
name: tss_min uint16
kernel_name: test_tss_16_min_uint
global_size: 11 0 0

arg_out: 0 buffer uint[176] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[176] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 
arg_in: 2 buffer uint[11] 2 1 0 4 1 1 4294967295 0 4294967295 0 4294967295

!*/

kernel void test_1_min_uint(global uint* out, global uint* in0, global uint* in1){
  out[get_global_id(0)] = min(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_min_uint(global uint* out, global uint* in0, global uint* in1){
  vstore2(min(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_min_uint(global uint* out, global uint* in0, global uint* in1){
  vstore4(min(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_min_uint(global uint* out, global uint* in0, global uint* in1){
  vstore8(min(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_min_uint(global uint* out, global uint* in0, global uint* in1){
  vstore16(min(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_min_uint(global uint* out, global uint* in0, global uint* in1){
  vstore2(min(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_min_uint(global uint* out, global uint* in0, global uint* in1){
  vstore4(min(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_min_uint(global uint* out, global uint* in0, global uint* in1){
  vstore8(min(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_min_uint(global uint* out, global uint* in0, global uint* in1){
  vstore16(min(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

