/*!
[config]
name: Test uint mad_hi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: mad_hi uint1
kernel_name: test_1_mad_hi_uint
global_size: 8 0 0

arg_out: 0 buffer uint[8] 2 2 4 1 4294967293 0 4294967295 3  tolerance 0 
arg_in: 1 buffer uint[8] 2147483647 0 12 4294967295 4294967295 0 0 4294967295 
arg_in: 2 buffer uint[8] 3 2 4 1 4294967295 0 4294967295 2 
arg_in: 3 buffer uint[8] 1 2 4 1 4294967295 0 4294967295 2 

[test]
name: mad_hi uint2
kernel_name: test_2_mad_hi_uint
global_size: 8 0 0

arg_out: 0 buffer uint[16] 2 2 2 2 4 4 1 1 4294967293 4294967293 0 0 4294967295 4294967295 3 3  tolerance 0 
arg_in: 1 buffer uint[16] 2147483647 2147483647 0 0 12 12 4294967295 4294967295 4294967295 4294967295 0 0 0 0 4294967295 4294967295 
arg_in: 2 buffer uint[16] 3 3 2 2 4 4 1 1 4294967295 4294967295 0 0 4294967295 4294967295 2 2 
arg_in: 3 buffer uint[16] 1 1 2 2 4 4 1 1 4294967295 4294967295 0 0 4294967295 4294967295 2 2 

[test]
name: mad_hi uint4
kernel_name: test_4_mad_hi_uint
global_size: 8 0 0

arg_out: 0 buffer uint[32] 2 2 2 2 2 2 2 2 4 4 4 4 1 1 1 1 4294967293 4294967293 4294967293 4294967293 0 0 0 0 4294967295 4294967295 4294967295 4294967295 3 3 3 3  tolerance 0 
arg_in: 1 buffer uint[32] 2147483647 2147483647 2147483647 2147483647 0 0 0 0 12 12 12 12 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 
arg_in: 2 buffer uint[32] 3 3 3 3 2 2 2 2 4 4 4 4 1 1 1 1 4294967295 4294967295 4294967295 4294967295 0 0 0 0 4294967295 4294967295 4294967295 4294967295 2 2 2 2 
arg_in: 3 buffer uint[32] 1 1 1 1 2 2 2 2 4 4 4 4 1 1 1 1 4294967295 4294967295 4294967295 4294967295 0 0 0 0 4294967295 4294967295 4294967295 4294967295 2 2 2 2 

[test]
name: mad_hi uint8
kernel_name: test_8_mad_hi_uint
global_size: 8 0 0

arg_out: 0 buffer uint[64] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 3 3 3 3 3 3 3 3  tolerance 0 
arg_in: 1 buffer uint[64] 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 12 12 12 12 12 12 12 12 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 
arg_in: 2 buffer uint[64] 3 3 3 3 3 3 3 3 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 2 2 2 2 2 2 2 2 
arg_in: 3 buffer uint[64] 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 2 2 2 2 2 2 2 2 

[test]
name: mad_hi uint16
kernel_name: test_16_mad_hi_uint
global_size: 8 0 0

arg_out: 0 buffer uint[128] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 4294967293 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3  tolerance 0 
arg_in: 1 buffer uint[128] 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 
arg_in: 2 buffer uint[128] 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 
arg_in: 3 buffer uint[128] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 

!*/

kernel void test_1_mad_hi_uint(global uint* out, global uint* in0, global uint* in1, global uint* in2){
  out[get_global_id(0)] = mad_hi(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_mad_hi_uint(global uint* out, global uint* in0, global uint* in1, global uint* in2){
  vstore2(mad_hi(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_mad_hi_uint(global uint* out, global uint* in0, global uint* in1, global uint* in2){
  vstore4(mad_hi(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_mad_hi_uint(global uint* out, global uint* in0, global uint* in1, global uint* in2){
  vstore8(mad_hi(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_mad_hi_uint(global uint* out, global uint* in0, global uint* in1, global uint* in2){
  vstore16(mad_hi(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

