/*!
[config]
name: Test uint mad24 built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: mad24 uint1
kernel_name: test_1_mad24_uint
global_size: 4 0 0

arg_out: 0 buffer uint[4] 0 2 4278190080 520  tolerance 0 
arg_in: 1 buffer uint[4] 0 1 16777215 32 
arg_in: 2 buffer uint[4] 0 1 16777215 16 
arg_in: 3 buffer uint[4] 0 1 16777215 8 

[test]
name: mad24 uint2
kernel_name: test_2_mad24_uint
global_size: 4 0 0

arg_out: 0 buffer uint[8] 0 0 2 2 4278190080 4278190080 520 520  tolerance 0 
arg_in: 1 buffer uint[8] 0 0 1 1 16777215 16777215 32 32 
arg_in: 2 buffer uint[8] 0 0 1 1 16777215 16777215 16 16 
arg_in: 3 buffer uint[8] 0 0 1 1 16777215 16777215 8 8 

[test]
name: mad24 uint4
kernel_name: test_4_mad24_uint
global_size: 4 0 0

arg_out: 0 buffer uint[16] 0 0 0 0 2 2 2 2 4278190080 4278190080 4278190080 4278190080 520 520 520 520  tolerance 0 
arg_in: 1 buffer uint[16] 0 0 0 0 1 1 1 1 16777215 16777215 16777215 16777215 32 32 32 32 
arg_in: 2 buffer uint[16] 0 0 0 0 1 1 1 1 16777215 16777215 16777215 16777215 16 16 16 16 
arg_in: 3 buffer uint[16] 0 0 0 0 1 1 1 1 16777215 16777215 16777215 16777215 8 8 8 8 

[test]
name: mad24 uint8
kernel_name: test_8_mad24_uint
global_size: 4 0 0

arg_out: 0 buffer uint[32] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 520 520 520 520 520 520 520 520  tolerance 0 
arg_in: 1 buffer uint[32] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 32 32 32 32 32 32 32 32 
arg_in: 2 buffer uint[32] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16 16 16 16 16 16 16 16 
arg_in: 3 buffer uint[32] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 8 8 8 8 8 8 8 8 

[test]
name: mad24 uint16
kernel_name: test_16_mad24_uint
global_size: 4 0 0

arg_out: 0 buffer uint[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 4278190080 520 520 520 520 520 520 520 520 520 520 520 520 520 520 520 520  tolerance 0 
arg_in: 1 buffer uint[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 
arg_in: 2 buffer uint[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 
arg_in: 3 buffer uint[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 16777215 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 

!*/

kernel void test_1_mad24_uint(global uint* out, global uint* in0, global uint* in1, global uint* in2){
  out[get_global_id(0)] = mad24(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_mad24_uint(global uint* out, global uint* in0, global uint* in1, global uint* in2){
  vstore2(mad24(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_mad24_uint(global uint* out, global uint* in0, global uint* in1, global uint* in2){
  vstore4(mad24(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_mad24_uint(global uint* out, global uint* in0, global uint* in1, global uint* in2){
  vstore8(mad24(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_mad24_uint(global uint* out, global uint* in0, global uint* in1, global uint* in2){
  vstore16(mad24(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

