/*!
[config]
name: Test uint hadd built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: hadd uint1
kernel_name: test_1_hadd_uint
global_size: 7 0 0

arg_out: 0 buffer uint[7] 32 0 10 4294967295 0 2147483647 2147483647  tolerance 0 
arg_in: 1 buffer uint[7] 32 1 12 4294967295 0 4294967295 0 
arg_in: 2 buffer uint[7] 33 0 8 4294967295 0 0 4294967295 

[test]
name: hadd uint2
kernel_name: test_2_hadd_uint
global_size: 7 0 0

arg_out: 0 buffer uint[14] 32 32 0 0 10 10 4294967295 4294967295 0 0 2147483647 2147483647 2147483647 2147483647  tolerance 0 
arg_in: 1 buffer uint[14] 32 32 1 1 12 12 4294967295 4294967295 0 0 4294967295 4294967295 0 0 
arg_in: 2 buffer uint[14] 33 33 0 0 8 8 4294967295 4294967295 0 0 0 0 4294967295 4294967295 

[test]
name: hadd uint4
kernel_name: test_4_hadd_uint
global_size: 7 0 0

arg_out: 0 buffer uint[28] 32 32 32 32 0 0 0 0 10 10 10 10 4294967295 4294967295 4294967295 4294967295 0 0 0 0 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647  tolerance 0 
arg_in: 1 buffer uint[28] 32 32 32 32 1 1 1 1 12 12 12 12 4294967295 4294967295 4294967295 4294967295 0 0 0 0 4294967295 4294967295 4294967295 4294967295 0 0 0 0 
arg_in: 2 buffer uint[28] 33 33 33 33 0 0 0 0 8 8 8 8 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 

[test]
name: hadd uint8
kernel_name: test_8_hadd_uint
global_size: 7 0 0

arg_out: 0 buffer uint[56] 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 10 10 10 10 10 10 10 10 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647  tolerance 0 
arg_in: 1 buffer uint[56] 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uint[56] 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 

[test]
name: hadd uint16
kernel_name: test_16_hadd_uint
global_size: 7 0 0

arg_out: 0 buffer uint[112] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647  tolerance 0 
arg_in: 1 buffer uint[112] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uint[112] 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 

!*/

kernel void test_1_hadd_uint(global uint* out, global uint* in0, global uint* in1){
  out[get_global_id(0)] = hadd(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_hadd_uint(global uint* out, global uint* in0, global uint* in1){
  vstore2(hadd(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_hadd_uint(global uint* out, global uint* in0, global uint* in1){
  vstore4(hadd(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_hadd_uint(global uint* out, global uint* in0, global uint* in1){
  vstore8(hadd(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_hadd_uint(global uint* out, global uint* in0, global uint* in1){
  vstore16(hadd(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

