/*!
[config]
name: Test uint clz built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: clz uint1
kernel_name: test_1_clz_uint
global_size: 5 0 0

arg_out: 0 buffer uint[5] 31 25 32 0 32  tolerance 0 
arg_in: 1 buffer uint[5] 1 64 0 4294967295 0 

[test]
name: clz uint2
kernel_name: test_2_clz_uint
global_size: 5 0 0

arg_out: 0 buffer uint[10] 31 31 25 25 32 32 0 0 32 32  tolerance 0 
arg_in: 1 buffer uint[10] 1 1 64 64 0 0 4294967295 4294967295 0 0 

[test]
name: clz uint4
kernel_name: test_4_clz_uint
global_size: 5 0 0

arg_out: 0 buffer uint[20] 31 31 31 31 25 25 25 25 32 32 32 32 0 0 0 0 32 32 32 32  tolerance 0 
arg_in: 1 buffer uint[20] 1 1 1 1 64 64 64 64 0 0 0 0 4294967295 4294967295 4294967295 4294967295 0 0 0 0 

[test]
name: clz uint8
kernel_name: test_8_clz_uint
global_size: 5 0 0

arg_out: 0 buffer uint[40] 31 31 31 31 31 31 31 31 25 25 25 25 25 25 25 25 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 32 32 32 32 32 32 32 32  tolerance 0 
arg_in: 1 buffer uint[40] 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 

[test]
name: clz uint16
kernel_name: test_16_clz_uint
global_size: 5 0 0

arg_out: 0 buffer uint[80] 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32  tolerance 0 
arg_in: 1 buffer uint[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

!*/

kernel void test_1_clz_uint(global uint* out, global uint* in0){
  out[get_global_id(0)] = clz(in0[get_global_id(0)]);
}

kernel void test_2_clz_uint(global uint* out, global uint* in0){
  vstore2(clz(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_clz_uint(global uint* out, global uint* in0){
  vstore4(clz(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_clz_uint(global uint* out, global uint* in0){
  vstore8(clz(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_clz_uint(global uint* out, global uint* in0){
  vstore16(clz(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

