/*!
[config]
name: Test uint abs_diff built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: abs_diff uint1
kernel_name: test_1_abs_diff_uint
global_size: 5 0 0

arg_out: 0 buffer uint[5] 0 1 1 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[5] 0 1 0 0 4294967295 
arg_in: 2 buffer uint[5] 0 0 1 4294967295 0 

[test]
name: abs_diff uint2
kernel_name: test_2_abs_diff_uint
global_size: 5 0 0

arg_out: 0 buffer uint[10] 0 0 1 1 1 1 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[10] 0 0 1 1 0 0 0 0 4294967295 4294967295 
arg_in: 2 buffer uint[10] 0 0 0 0 1 1 4294967295 4294967295 0 0 

[test]
name: abs_diff uint4
kernel_name: test_4_abs_diff_uint
global_size: 5 0 0

arg_out: 0 buffer uint[20] 0 0 0 0 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[20] 0 0 0 0 1 1 1 1 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 
arg_in: 2 buffer uint[20] 0 0 0 0 0 0 0 0 1 1 1 1 4294967295 4294967295 4294967295 4294967295 0 0 0 0 

[test]
name: abs_diff uint8
kernel_name: test_8_abs_diff_uint
global_size: 5 0 0

arg_out: 0 buffer uint[40] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[40] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 
arg_in: 2 buffer uint[40] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 

[test]
name: abs_diff uint16
kernel_name: test_16_abs_diff_uint
global_size: 5 0 0

arg_out: 0 buffer uint[80] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[80] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 
arg_in: 2 buffer uint[80] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

!*/

kernel void test_1_abs_diff_uint(global uint* out, global uint* in0, global uint* in1){
  out[get_global_id(0)] = abs_diff(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_abs_diff_uint(global uint* out, global uint* in0, global uint* in1){
  vstore2(abs_diff(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_abs_diff_uint(global uint* out, global uint* in0, global uint* in1){
  vstore4(abs_diff(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_abs_diff_uint(global uint* out, global uint* in0, global uint* in1){
  vstore8(abs_diff(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_abs_diff_uint(global uint* out, global uint* in0, global uint* in1){
  vstore16(abs_diff(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

