/*!
[config]
name: Test uint abs built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: abs uint1
kernel_name: test_1_abs_uint
global_size: 4 0 0

arg_out: 0 buffer uint[4] 0 2 0 4294967295  tolerance 0 
arg_in: 1 buffer uint[4] 0 2 0 4294967295 

[test]
name: abs uint2
kernel_name: test_2_abs_uint
global_size: 4 0 0

arg_out: 0 buffer uint[8] 0 0 2 2 0 0 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[8] 0 0 2 2 0 0 4294967295 4294967295 

[test]
name: abs uint4
kernel_name: test_4_abs_uint
global_size: 4 0 0

arg_out: 0 buffer uint[16] 0 0 0 0 2 2 2 2 0 0 0 0 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[16] 0 0 0 0 2 2 2 2 0 0 0 0 4294967295 4294967295 4294967295 4294967295 

[test]
name: abs uint8
kernel_name: test_8_abs_uint
global_size: 4 0 0

arg_out: 0 buffer uint[32] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[32] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 

[test]
name: abs uint16
kernel_name: test_16_abs_uint
global_size: 4 0 0

arg_out: 0 buffer uint[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295  tolerance 0 
arg_in: 1 buffer uint[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 4294967295 

!*/

kernel void test_1_abs_uint(global uint* out, global uint* in0){
  out[get_global_id(0)] = abs(in0[get_global_id(0)]);
}

kernel void test_2_abs_uint(global uint* out, global uint* in0){
  vstore2(abs(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_abs_uint(global uint* out, global uint* in0){
  vstore4(abs(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_abs_uint(global uint* out, global uint* in0){
  vstore8(abs(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_abs_uint(global uint* out, global uint* in0){
  vstore16(abs(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

