/*!
[config]
name: Test uchar upsample built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: upsample uchar1
kernel_name: test_1_upsample_uchar
global_size: 6 0 0

arg_out: 0 buffer ushort[6] 256 257 65535 0 255 263  tolerance 0 
arg_in: 1 buffer uchar[6] 1 1 255 0 0 1 
arg_in: 2 buffer uchar[6] 0 1 255 0 255 7 

[test]
name: upsample uchar2
kernel_name: test_2_upsample_uchar
global_size: 6 0 0

arg_out: 0 buffer ushort[12] 256 256 257 257 65535 65535 0 0 255 255 263 263  tolerance 0 
arg_in: 1 buffer uchar[12] 1 1 1 1 255 255 0 0 0 0 1 1 
arg_in: 2 buffer uchar[12] 0 0 1 1 255 255 0 0 255 255 7 7 

[test]
name: upsample uchar4
kernel_name: test_4_upsample_uchar
global_size: 6 0 0

arg_out: 0 buffer ushort[24] 256 256 256 256 257 257 257 257 65535 65535 65535 65535 0 0 0 0 255 255 255 255 263 263 263 263  tolerance 0 
arg_in: 1 buffer uchar[24] 1 1 1 1 1 1 1 1 255 255 255 255 0 0 0 0 0 0 0 0 1 1 1 1 
arg_in: 2 buffer uchar[24] 0 0 0 0 1 1 1 1 255 255 255 255 0 0 0 0 255 255 255 255 7 7 7 7 

[test]
name: upsample uchar8
kernel_name: test_8_upsample_uchar
global_size: 6 0 0

arg_out: 0 buffer ushort[48] 256 256 256 256 256 256 256 256 257 257 257 257 257 257 257 257 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 263 263 263 263 263 263 263 263  tolerance 0 
arg_in: 1 buffer uchar[48] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 
arg_in: 2 buffer uchar[48] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 7 7 7 7 7 7 7 7 

[test]
name: upsample uchar16
kernel_name: test_16_upsample_uchar
global_size: 6 0 0

arg_out: 0 buffer ushort[96] 256 256 256 256 256 256 256 256 256 256 256 256 256 256 256 256 257 257 257 257 257 257 257 257 257 257 257 257 257 257 257 257 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 263 263 263 263 263 263 263 263 263 263 263 263 263 263 263 263  tolerance 0 
arg_in: 1 buffer uchar[96] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer uchar[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 

!*/

kernel void test_1_upsample_uchar(global ushort* out, global uchar* in0, global uchar* in1){
  out[get_global_id(0)] = upsample(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_upsample_uchar(global ushort* out, global uchar* in0, global uchar* in1){
  vstore2(upsample(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_upsample_uchar(global ushort* out, global uchar* in0, global uchar* in1){
  vstore4(upsample(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_upsample_uchar(global ushort* out, global uchar* in0, global uchar* in1){
  vstore8(upsample(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_upsample_uchar(global ushort* out, global uchar* in0, global uchar* in1){
  vstore16(upsample(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

