/*!
[config]
name: Test uchar sub_sat built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: sub_sat uchar1
kernel_name: test_1_sub_sat_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[7] 1 25 255 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[7] 1 57 255 255 0 0 0 
arg_in: 2 buffer uchar[7] 0 32 0 255 0 255 128 

[test]
name: sub_sat uchar2
kernel_name: test_2_sub_sat_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[14] 1 1 25 25 255 255 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[14] 1 1 57 57 255 255 255 255 0 0 0 0 0 0 
arg_in: 2 buffer uchar[14] 0 0 32 32 0 0 255 255 0 0 255 255 128 128 

[test]
name: sub_sat uchar4
kernel_name: test_4_sub_sat_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[28] 1 1 1 1 25 25 25 25 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[28] 1 1 1 1 57 57 57 57 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uchar[28] 0 0 0 0 32 32 32 32 0 0 0 0 255 255 255 255 0 0 0 0 255 255 255 255 128 128 128 128 

[test]
name: sub_sat uchar8
kernel_name: test_8_sub_sat_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[56] 1 1 1 1 1 1 1 1 25 25 25 25 25 25 25 25 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[56] 1 1 1 1 1 1 1 1 57 57 57 57 57 57 57 57 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uchar[56] 0 0 0 0 0 0 0 0 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 128 128 128 128 128 128 128 128 

[test]
name: sub_sat uchar16
kernel_name: test_16_sub_sat_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 25 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 57 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uchar[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 

!*/

kernel void test_1_sub_sat_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  out[get_global_id(0)] = sub_sat(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_sub_sat_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore2(sub_sat(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_sub_sat_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore4(sub_sat(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_sub_sat_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore8(sub_sat(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_sub_sat_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore16(sub_sat(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

