/*!
[config]
name: Test uchar rotate built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: rotate uchar1
kernel_name: test_1_rotate_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[7] 1 8 1 2 1 128 128  tolerance 0 
arg_in: 1 buffer uchar[7] 1 1 1 1 1 1 1 
arg_in: 2 buffer uchar[7] 0 3 8 9 80 7 7 

[test]
name: rotate uchar2
kernel_name: test_2_rotate_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[14] 1 1 8 8 1 1 2 2 1 1 128 128 128 128  tolerance 0 
arg_in: 1 buffer uchar[14] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer uchar[14] 0 0 3 3 8 8 9 9 80 80 7 7 7 7 

[test]
name: rotate uchar4
kernel_name: test_4_rotate_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[28] 1 1 1 1 8 8 8 8 1 1 1 1 2 2 2 2 1 1 1 1 128 128 128 128 128 128 128 128  tolerance 0 
arg_in: 1 buffer uchar[28] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer uchar[28] 0 0 0 0 3 3 3 3 8 8 8 8 9 9 9 9 80 80 80 80 7 7 7 7 7 7 7 7 

[test]
name: rotate uchar8
kernel_name: test_8_rotate_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[56] 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128  tolerance 0 
arg_in: 1 buffer uchar[56] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer uchar[56] 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 8 8 8 8 8 8 8 8 9 9 9 9 9 9 9 9 80 80 80 80 80 80 80 80 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 

[test]
name: rotate uchar16
kernel_name: test_16_rotate_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128 128  tolerance 0 
arg_in: 1 buffer uchar[112] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer uchar[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 80 80 80 80 80 80 80 80 80 80 80 80 80 80 80 80 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 

!*/

kernel void test_1_rotate_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  out[get_global_id(0)] = rotate(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_rotate_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore2(rotate(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_rotate_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore4(rotate(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_rotate_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore8(rotate(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_rotate_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore16(rotate(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

