/*!
[config]
name: Test uchar rhadd built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: rhadd uchar1
kernel_name: test_1_rhadd_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[3] 33 1 10  tolerance 0 
arg_in: 1 buffer uchar[3] 32 1 12 
arg_in: 2 buffer uchar[3] 33 0 8 

[test]
name: rhadd uchar2
kernel_name: test_2_rhadd_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[6] 33 33 1 1 10 10  tolerance 0 
arg_in: 1 buffer uchar[6] 32 32 1 1 12 12 
arg_in: 2 buffer uchar[6] 33 33 0 0 8 8 

[test]
name: rhadd uchar4
kernel_name: test_4_rhadd_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[12] 33 33 33 33 1 1 1 1 10 10 10 10  tolerance 0 
arg_in: 1 buffer uchar[12] 32 32 32 32 1 1 1 1 12 12 12 12 
arg_in: 2 buffer uchar[12] 33 33 33 33 0 0 0 0 8 8 8 8 

[test]
name: rhadd uchar8
kernel_name: test_8_rhadd_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[24] 33 33 33 33 33 33 33 33 1 1 1 1 1 1 1 1 10 10 10 10 10 10 10 10  tolerance 0 
arg_in: 1 buffer uchar[24] 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 
arg_in: 2 buffer uchar[24] 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 

[test]
name: rhadd uchar16
kernel_name: test_16_rhadd_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[48] 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10  tolerance 0 
arg_in: 1 buffer uchar[48] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 
arg_in: 2 buffer uchar[48] 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 

!*/

kernel void test_1_rhadd_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  out[get_global_id(0)] = rhadd(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_rhadd_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore2(rhadd(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_rhadd_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore4(rhadd(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_rhadd_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore8(rhadd(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_rhadd_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore16(rhadd(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

