/*!
[config]
name: Test uchar popcount built-in on CL 1.1
clc_version_min: 12
dimensions: 1

[test]
name: popcount uchar1
kernel_name: test_1_popcount_uchar
global_size: 5 0 0

arg_out: 0 buffer uchar[5] 1 2 0 8 0  tolerance 0 
arg_in: 1 buffer uchar[5] 1 3 0 255 0 

[test]
name: popcount uchar2
kernel_name: test_2_popcount_uchar
global_size: 5 0 0

arg_out: 0 buffer uchar[10] 1 1 2 2 0 0 8 8 0 0  tolerance 0 
arg_in: 1 buffer uchar[10] 1 1 3 3 0 0 255 255 0 0 

[test]
name: popcount uchar4
kernel_name: test_4_popcount_uchar
global_size: 5 0 0

arg_out: 0 buffer uchar[20] 1 1 1 1 2 2 2 2 0 0 0 0 8 8 8 8 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[20] 1 1 1 1 3 3 3 3 0 0 0 0 255 255 255 255 0 0 0 0 

[test]
name: popcount uchar8
kernel_name: test_8_popcount_uchar
global_size: 5 0 0

arg_out: 0 buffer uchar[40] 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[40] 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 

[test]
name: popcount uchar16
kernel_name: test_16_popcount_uchar
global_size: 5 0 0

arg_out: 0 buffer uchar[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

!*/

kernel void test_1_popcount_uchar(global uchar* out, global uchar* in0){
  out[get_global_id(0)] = popcount(in0[get_global_id(0)]);
}

kernel void test_2_popcount_uchar(global uchar* out, global uchar* in0){
  vstore2(popcount(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_popcount_uchar(global uchar* out, global uchar* in0){
  vstore4(popcount(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_popcount_uchar(global uchar* out, global uchar* in0){
  vstore8(popcount(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_popcount_uchar(global uchar* out, global uchar* in0){
  vstore16(popcount(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

