/*!
[config]
name: Test uchar max built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: max uchar1
kernel_name: test_1_max_uchar
global_size: 10 0 0

arg_out: 0 buffer uchar[10] 92 2 12 255 1 255 0 255 255 0  tolerance 0 
arg_in: 1 buffer uchar[10] 92 2 12 255 0 255 0 0 255 0 
arg_in: 2 buffer uchar[10] 2 0 4 1 1 255 0 255 0 0 

[test]
name: max uchar2
kernel_name: test_2_max_uchar
global_size: 10 0 0

arg_out: 0 buffer uchar[20] 92 92 2 2 12 12 255 255 1 1 255 255 0 0 255 255 255 255 0 0  tolerance 0 
arg_in: 1 buffer uchar[20] 92 92 2 2 12 12 255 255 0 0 255 255 0 0 0 0 255 255 0 0 
arg_in: 2 buffer uchar[20] 2 2 0 0 4 4 1 1 1 1 255 255 0 0 255 255 0 0 0 0 

[test]
name: tss_max uchar2
kernel_name: test_tss_2_max_uchar
global_size: 10 0 0

arg_out: 0 buffer uchar[20] 92 92 2 2 12 12 255 255 1 1 255 255 0 0 255 255 255 255 0 0  tolerance 0 
arg_in: 1 buffer uchar[20] 92 92 2 2 12 12 255 255 0 0 255 255 0 0 0 0 255 255 0 0 
arg_in: 2 buffer uchar[10] 2 0 4 1 1 255 0 255 0 0

[test]
name: max uchar4
kernel_name: test_4_max_uchar
global_size: 10 0 0

arg_out: 0 buffer uchar[40] 92 92 92 92 2 2 2 2 12 12 12 12 255 255 255 255 1 1 1 1 255 255 255 255 0 0 0 0 255 255 255 255 255 255 255 255 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[40] 92 92 92 92 2 2 2 2 12 12 12 12 255 255 255 255 0 0 0 0 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 0 0 0 0 
arg_in: 2 buffer uchar[40] 2 2 2 2 0 0 0 0 4 4 4 4 1 1 1 1 1 1 1 1 255 255 255 255 0 0 0 0 255 255 255 255 0 0 0 0 0 0 0 0 

[test]
name: tss_max uchar4
kernel_name: test_tss_4_max_uchar
global_size: 10 0 0

arg_out: 0 buffer uchar[40] 92 92 92 92 2 2 2 2 12 12 12 12 255 255 255 255 1 1 1 1 255 255 255 255 0 0 0 0 255 255 255 255 255 255 255 255 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[40] 92 92 92 92 2 2 2 2 12 12 12 12 255 255 255 255 0 0 0 0 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 0 0 0 0 
arg_in: 2 buffer uchar[10] 2 0 4 1 1 255 0 255 0 0

[test]
name: max uchar8
kernel_name: test_8_max_uchar
global_size: 10 0 0

arg_out: 0 buffer uchar[80] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[80] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uchar[80] 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

[test]
name: tss_max uchar8
kernel_name: test_tss_8_max_uchar
global_size: 10 0 0

arg_out: 0 buffer uchar[80] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[80] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uchar[10] 2 0 4 1 1 255 0 255 0 0

[test]
name: max uchar16
kernel_name: test_16_max_uchar
global_size: 10 0 0

arg_out: 0 buffer uchar[160] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[160] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uchar[160] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

[test]
name: tss_max uchar16
kernel_name: test_tss_16_max_uchar
global_size: 10 0 0

arg_out: 0 buffer uchar[160] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer uchar[160] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uchar[10] 2 0 4 1 1 255 0 255 0 0

!*/

kernel void test_1_max_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  out[get_global_id(0)] = max(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_max_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore2(max(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_max_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore4(max(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_max_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore8(max(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_max_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore16(max(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_max_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore2(max(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_max_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore4(max(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_max_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore8(max(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_max_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore16(max(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

