/*!
[config]
name: Test uchar mad_sat built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: mad_sat uchar1
kernel_name: test_1_mad_sat_uchar
global_size: 9 0 0

arg_out: 0 buffer uchar[9] 52 255 93 0 255 255 2 0 255  tolerance 0 
arg_in: 1 buffer uchar[9] 12 255 92 0 255 255 0 0 0 
arg_in: 2 buffer uchar[9] 4 1 1 0 2 255 2 0 255 
arg_in: 3 buffer uchar[9] 4 1 1 0 2 255 2 0 255 

[test]
name: mad_sat uchar2
kernel_name: test_2_mad_sat_uchar
global_size: 9 0 0

arg_out: 0 buffer uchar[18] 52 52 255 255 93 93 0 0 255 255 255 255 2 2 0 0 255 255  tolerance 0 
arg_in: 1 buffer uchar[18] 12 12 255 255 92 92 0 0 255 255 255 255 0 0 0 0 0 0 
arg_in: 2 buffer uchar[18] 4 4 1 1 1 1 0 0 2 2 255 255 2 2 0 0 255 255 
arg_in: 3 buffer uchar[18] 4 4 1 1 1 1 0 0 2 2 255 255 2 2 0 0 255 255 

[test]
name: mad_sat uchar4
kernel_name: test_4_mad_sat_uchar
global_size: 9 0 0

arg_out: 0 buffer uchar[36] 52 52 52 52 255 255 255 255 93 93 93 93 0 0 0 0 255 255 255 255 255 255 255 255 2 2 2 2 0 0 0 0 255 255 255 255  tolerance 0 
arg_in: 1 buffer uchar[36] 12 12 12 12 255 255 255 255 92 92 92 92 0 0 0 0 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uchar[36] 4 4 4 4 1 1 1 1 1 1 1 1 0 0 0 0 2 2 2 2 255 255 255 255 2 2 2 2 0 0 0 0 255 255 255 255 
arg_in: 3 buffer uchar[36] 4 4 4 4 1 1 1 1 1 1 1 1 0 0 0 0 2 2 2 2 255 255 255 255 2 2 2 2 0 0 0 0 255 255 255 255 

[test]
name: mad_sat uchar8
kernel_name: test_8_mad_sat_uchar
global_size: 9 0 0

arg_out: 0 buffer uchar[72] 52 52 52 52 52 52 52 52 255 255 255 255 255 255 255 255 93 93 93 93 93 93 93 93 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255  tolerance 0 
arg_in: 1 buffer uchar[72] 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 92 92 92 92 92 92 92 92 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uchar[72] 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 255 255 255 255 255 255 255 255 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 
arg_in: 3 buffer uchar[72] 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 255 255 255 255 255 255 255 255 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 

[test]
name: mad_sat uchar16
kernel_name: test_16_mad_sat_uchar
global_size: 9 0 0

arg_out: 0 buffer uchar[144] 52 52 52 52 52 52 52 52 52 52 52 52 52 52 52 52 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 93 93 93 93 93 93 93 93 93 93 93 93 93 93 93 93 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255  tolerance 0 
arg_in: 1 buffer uchar[144] 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uchar[144] 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 
arg_in: 3 buffer uchar[144] 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 

!*/

kernel void test_1_mad_sat_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  out[get_global_id(0)] = mad_sat(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_mad_sat_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore2(mad_sat(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_mad_sat_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore4(mad_sat(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_mad_sat_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore8(mad_sat(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_mad_sat_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore16(mad_sat(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

