/*!
[config]
name: Test uchar mad_hi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: mad_hi uchar1
kernel_name: test_1_mad_hi_uchar
global_size: 8 0 0

arg_out: 0 buffer uchar[8] 2 2 4 1 253 0 255 3  tolerance 0 
arg_in: 1 buffer uchar[8] 127 0 12 255 255 0 0 255 
arg_in: 2 buffer uchar[8] 3 2 4 1 255 0 255 2 
arg_in: 3 buffer uchar[8] 1 2 4 1 255 0 255 2 

[test]
name: mad_hi uchar2
kernel_name: test_2_mad_hi_uchar
global_size: 8 0 0

arg_out: 0 buffer uchar[16] 2 2 2 2 4 4 1 1 253 253 0 0 255 255 3 3  tolerance 0 
arg_in: 1 buffer uchar[16] 127 127 0 0 12 12 255 255 255 255 0 0 0 0 255 255 
arg_in: 2 buffer uchar[16] 3 3 2 2 4 4 1 1 255 255 0 0 255 255 2 2 
arg_in: 3 buffer uchar[16] 1 1 2 2 4 4 1 1 255 255 0 0 255 255 2 2 

[test]
name: mad_hi uchar4
kernel_name: test_4_mad_hi_uchar
global_size: 8 0 0

arg_out: 0 buffer uchar[32] 2 2 2 2 2 2 2 2 4 4 4 4 1 1 1 1 253 253 253 253 0 0 0 0 255 255 255 255 3 3 3 3  tolerance 0 
arg_in: 1 buffer uchar[32] 127 127 127 127 0 0 0 0 12 12 12 12 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 
arg_in: 2 buffer uchar[32] 3 3 3 3 2 2 2 2 4 4 4 4 1 1 1 1 255 255 255 255 0 0 0 0 255 255 255 255 2 2 2 2 
arg_in: 3 buffer uchar[32] 1 1 1 1 2 2 2 2 4 4 4 4 1 1 1 1 255 255 255 255 0 0 0 0 255 255 255 255 2 2 2 2 

[test]
name: mad_hi uchar8
kernel_name: test_8_mad_hi_uchar
global_size: 8 0 0

arg_out: 0 buffer uchar[64] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 253 253 253 253 253 253 253 253 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 3 3 3 3 3 3 3 3  tolerance 0 
arg_in: 1 buffer uchar[64] 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 
arg_in: 2 buffer uchar[64] 3 3 3 3 3 3 3 3 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 2 2 2 2 2 2 2 2 
arg_in: 3 buffer uchar[64] 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 2 2 2 2 2 2 2 2 

[test]
name: mad_hi uchar16
kernel_name: test_16_mad_hi_uchar
global_size: 8 0 0

arg_out: 0 buffer uchar[128] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 253 253 253 253 253 253 253 253 253 253 253 253 253 253 253 253 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3  tolerance 0 
arg_in: 1 buffer uchar[128] 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 
arg_in: 2 buffer uchar[128] 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 
arg_in: 3 buffer uchar[128] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 

!*/

kernel void test_1_mad_hi_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  out[get_global_id(0)] = mad_hi(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_mad_hi_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore2(mad_hi(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_mad_hi_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore4(mad_hi(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_mad_hi_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore8(mad_hi(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_mad_hi_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore16(mad_hi(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

