/*!
[config]
name: Test uchar hadd built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: hadd uchar1
kernel_name: test_1_hadd_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[7] 32 0 10 255 0 127 127  tolerance 0 
arg_in: 1 buffer uchar[7] 32 1 12 255 0 255 0 
arg_in: 2 buffer uchar[7] 33 0 8 255 0 0 255 

[test]
name: hadd uchar2
kernel_name: test_2_hadd_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[14] 32 32 0 0 10 10 255 255 0 0 127 127 127 127  tolerance 0 
arg_in: 1 buffer uchar[14] 32 32 1 1 12 12 255 255 0 0 255 255 0 0 
arg_in: 2 buffer uchar[14] 33 33 0 0 8 8 255 255 0 0 0 0 255 255 

[test]
name: hadd uchar4
kernel_name: test_4_hadd_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[28] 32 32 32 32 0 0 0 0 10 10 10 10 255 255 255 255 0 0 0 0 127 127 127 127 127 127 127 127  tolerance 0 
arg_in: 1 buffer uchar[28] 32 32 32 32 1 1 1 1 12 12 12 12 255 255 255 255 0 0 0 0 255 255 255 255 0 0 0 0 
arg_in: 2 buffer uchar[28] 33 33 33 33 0 0 0 0 8 8 8 8 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 

[test]
name: hadd uchar8
kernel_name: test_8_hadd_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[56] 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 10 10 10 10 10 10 10 10 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127  tolerance 0 
arg_in: 1 buffer uchar[56] 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uchar[56] 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 

[test]
name: hadd uchar16
kernel_name: test_16_hadd_uchar
global_size: 7 0 0

arg_out: 0 buffer uchar[112] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127 127  tolerance 0 
arg_in: 1 buffer uchar[112] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 2 buffer uchar[112] 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 

!*/

kernel void test_1_hadd_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  out[get_global_id(0)] = hadd(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_hadd_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore2(hadd(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_hadd_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore4(hadd(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_hadd_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore8(hadd(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_hadd_uchar(global uchar* out, global uchar* in0, global uchar* in1){
  vstore16(hadd(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

