/*!
[config]
name: Test uchar clz built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: clz uchar1
kernel_name: test_1_clz_uchar
global_size: 5 0 0

arg_out: 0 buffer uchar[5] 7 1 8 0 8  tolerance 0 
arg_in: 1 buffer uchar[5] 1 64 0 255 0 

[test]
name: clz uchar2
kernel_name: test_2_clz_uchar
global_size: 5 0 0

arg_out: 0 buffer uchar[10] 7 7 1 1 8 8 0 0 8 8  tolerance 0 
arg_in: 1 buffer uchar[10] 1 1 64 64 0 0 255 255 0 0 

[test]
name: clz uchar4
kernel_name: test_4_clz_uchar
global_size: 5 0 0

arg_out: 0 buffer uchar[20] 7 7 7 7 1 1 1 1 8 8 8 8 0 0 0 0 8 8 8 8  tolerance 0 
arg_in: 1 buffer uchar[20] 1 1 1 1 64 64 64 64 0 0 0 0 255 255 255 255 0 0 0 0 

[test]
name: clz uchar8
kernel_name: test_8_clz_uchar
global_size: 5 0 0

arg_out: 0 buffer uchar[40] 7 7 7 7 7 7 7 7 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8  tolerance 0 
arg_in: 1 buffer uchar[40] 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 

[test]
name: clz uchar16
kernel_name: test_16_clz_uchar
global_size: 5 0 0

arg_out: 0 buffer uchar[80] 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8  tolerance 0 
arg_in: 1 buffer uchar[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

!*/

kernel void test_1_clz_uchar(global uchar* out, global uchar* in0){
  out[get_global_id(0)] = clz(in0[get_global_id(0)]);
}

kernel void test_2_clz_uchar(global uchar* out, global uchar* in0){
  vstore2(clz(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_clz_uchar(global uchar* out, global uchar* in0){
  vstore4(clz(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_clz_uchar(global uchar* out, global uchar* in0){
  vstore8(clz(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_clz_uchar(global uchar* out, global uchar* in0){
  vstore16(clz(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

