/*!
[config]
name: Test uchar clamp built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: clamp uchar1
kernel_name: test_1_clamp_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[3] 64 0 1  tolerance 0 
arg_in: 1 buffer uchar[3] 92 0 64 
arg_in: 2 buffer uchar[3] 0 0 0 
arg_in: 3 buffer uchar[3] 64 0 1 

[test]
name: clamp uchar2
kernel_name: test_2_clamp_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[6] 64 64 0 0 1 1  tolerance 0 
arg_in: 1 buffer uchar[6] 92 92 0 0 64 64 
arg_in: 2 buffer uchar[6] 0 0 0 0 0 0 
arg_in: 3 buffer uchar[6] 64 64 0 0 1 1 

[test]
name: tss_clamp uchar2
kernel_name: test_tss_2_clamp_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[6] 64 64 0 0 1 1  tolerance 0 
arg_in: 1 buffer uchar[6] 92 92 0 0 64 64 
arg_in: 2 buffer uchar[3] 0 0 0
arg_in: 3 buffer uchar[3] 64 0 1

[test]
name: clamp uchar4
kernel_name: test_4_clamp_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[12] 64 64 64 64 0 0 0 0 1 1 1 1  tolerance 0 
arg_in: 1 buffer uchar[12] 92 92 92 92 0 0 0 0 64 64 64 64 
arg_in: 2 buffer uchar[12] 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 3 buffer uchar[12] 64 64 64 64 0 0 0 0 1 1 1 1 

[test]
name: tss_clamp uchar4
kernel_name: test_tss_4_clamp_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[12] 64 64 64 64 0 0 0 0 1 1 1 1  tolerance 0 
arg_in: 1 buffer uchar[12] 92 92 92 92 0 0 0 0 64 64 64 64 
arg_in: 2 buffer uchar[3] 0 0 0
arg_in: 3 buffer uchar[3] 64 0 1

[test]
name: clamp uchar8
kernel_name: test_8_clamp_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[24] 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer uchar[24] 92 92 92 92 92 92 92 92 0 0 0 0 0 0 0 0 64 64 64 64 64 64 64 64 
arg_in: 2 buffer uchar[24] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 3 buffer uchar[24] 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 

[test]
name: tss_clamp uchar8
kernel_name: test_tss_8_clamp_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[24] 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer uchar[24] 92 92 92 92 92 92 92 92 0 0 0 0 0 0 0 0 64 64 64 64 64 64 64 64 
arg_in: 2 buffer uchar[3] 0 0 0
arg_in: 3 buffer uchar[3] 64 0 1

[test]
name: clamp uchar16
kernel_name: test_16_clamp_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[48] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer uchar[48] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 
arg_in: 2 buffer uchar[48] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
arg_in: 3 buffer uchar[48] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 

[test]
name: tss_clamp uchar16
kernel_name: test_tss_16_clamp_uchar
global_size: 3 0 0

arg_out: 0 buffer uchar[48] 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer uchar[48] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 
arg_in: 2 buffer uchar[3] 0 0 0
arg_in: 3 buffer uchar[3] 64 0 1

!*/

kernel void test_1_clamp_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  out[get_global_id(0)] = clamp(in0[get_global_id(0)], in1[get_global_id(0)], in2[get_global_id(0)]);
}

kernel void test_2_clamp_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore2(clamp(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1), vload2(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_4_clamp_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore4(clamp(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1), vload4(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_8_clamp_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore8(clamp(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1), vload8(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_16_clamp_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore16(clamp(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1), vload16(get_global_id(0), in2)), get_global_id(0), out);
}

kernel void test_tss_2_clamp_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore2(clamp(vload2(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_clamp_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore4(clamp(vload4(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_clamp_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore8(clamp(vload8(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_clamp_uchar(global uchar* out, global uchar* in0, global uchar* in1, global uchar* in2){
  vstore16(clamp(vload16(get_global_id(0), in0), in1[get_global_id(0)], in2[get_global_id(0)]), get_global_id(0), out);
}

