/*!
[config]
name: Test short upsample built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: upsample short1
kernel_name: test_1_upsample_short
global_size: 8 0 0

arg_out: 0 buffer int[8] 65536 65537 2147483647 0 32767 65543 -1 -65536  tolerance 0 
arg_in: 1 buffer short[8] 1 1 32767 0 0 1 -1 -1 
arg_in: 2 buffer ushort[8] 0 1 65535 0 32767 7 65535 0 

[test]
name: upsample short2
kernel_name: test_2_upsample_short
global_size: 8 0 0

arg_out: 0 buffer int[16] 65536 65536 65537 65537 2147483647 2147483647 0 0 32767 32767 65543 65543 -1 -1 -65536 -65536  tolerance 0 
arg_in: 1 buffer short[16] 1 1 1 1 32767 32767 0 0 0 0 1 1 -1 -1 -1 -1 
arg_in: 2 buffer ushort[16] 0 0 1 1 65535 65535 0 0 32767 32767 7 7 65535 65535 0 0 

[test]
name: upsample short4
kernel_name: test_4_upsample_short
global_size: 8 0 0

arg_out: 0 buffer int[32] 65536 65536 65536 65536 65537 65537 65537 65537 2147483647 2147483647 2147483647 2147483647 0 0 0 0 32767 32767 32767 32767 65543 65543 65543 65543 -1 -1 -1 -1 -65536 -65536 -65536 -65536  tolerance 0 
arg_in: 1 buffer short[32] 1 1 1 1 1 1 1 1 32767 32767 32767 32767 0 0 0 0 0 0 0 0 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer ushort[32] 0 0 0 0 1 1 1 1 65535 65535 65535 65535 0 0 0 0 32767 32767 32767 32767 7 7 7 7 65535 65535 65535 65535 0 0 0 0 

[test]
name: upsample short8
kernel_name: test_8_upsample_short
global_size: 8 0 0

arg_out: 0 buffer int[64] 65536 65536 65536 65536 65536 65536 65536 65536 65537 65537 65537 65537 65537 65537 65537 65537 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 65543 65543 65543 65543 65543 65543 65543 65543 -1 -1 -1 -1 -1 -1 -1 -1 -65536 -65536 -65536 -65536 -65536 -65536 -65536 -65536  tolerance 0 
arg_in: 1 buffer short[64] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer ushort[64] 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 7 7 7 7 7 7 7 7 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 

[test]
name: upsample short16
kernel_name: test_16_upsample_short
global_size: 8 0 0

arg_out: 0 buffer int[128] 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65536 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 65537 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 2147483647 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 65543 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -65536 -65536 -65536 -65536 -65536 -65536 -65536 -65536 -65536 -65536 -65536 -65536 -65536 -65536 -65536 -65536  tolerance 0 
arg_in: 1 buffer short[128] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 
arg_in: 2 buffer ushort[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 7 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 65535 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 

!*/

kernel void test_1_upsample_short(global int* out, global short* in0, global ushort* in1){
  out[get_global_id(0)] = upsample(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_upsample_short(global int* out, global short* in0, global ushort* in1){
  vstore2(upsample(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_upsample_short(global int* out, global short* in0, global ushort* in1){
  vstore4(upsample(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_upsample_short(global int* out, global short* in0, global ushort* in1){
  vstore8(upsample(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_upsample_short(global int* out, global short* in0, global ushort* in1){
  vstore16(upsample(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

