/*!
[config]
name: Test short rotate built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: rotate short1
kernel_name: test_1_rotate_short
global_size: 13 0 0

arg_out: 0 buffer short[13] 1 8 1 2 1 -32768 -32768 8192 1 -32768 16384 -32768 32767  tolerance 0 
arg_in: 1 buffer short[13] 1 1 1 1 1 1 1 1 1 1 1 1 -2 
arg_in: 2 buffer short[13] 0 3 16 17 160 15 -1 -3 -16 -17 -18 15 -1 

[test]
name: rotate short2
kernel_name: test_2_rotate_short
global_size: 13 0 0

arg_out: 0 buffer short[26] 1 1 8 8 1 1 2 2 1 1 -32768 -32768 -32768 -32768 8192 8192 1 1 -32768 -32768 16384 16384 -32768 -32768 32767 32767  tolerance 0 
arg_in: 1 buffer short[26] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2 -2 
arg_in: 2 buffer short[26] 0 0 3 3 16 16 17 17 160 160 15 15 -1 -1 -3 -3 -16 -16 -17 -17 -18 -18 15 15 -1 -1 

[test]
name: rotate short4
kernel_name: test_4_rotate_short
global_size: 13 0 0

arg_out: 0 buffer short[52] 1 1 1 1 8 8 8 8 1 1 1 1 2 2 2 2 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 8192 8192 8192 8192 1 1 1 1 -32768 -32768 -32768 -32768 16384 16384 16384 16384 -32768 -32768 -32768 -32768 32767 32767 32767 32767  tolerance 0 
arg_in: 1 buffer short[52] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2 -2 -2 -2 
arg_in: 2 buffer short[52] 0 0 0 0 3 3 3 3 16 16 16 16 17 17 17 17 160 160 160 160 15 15 15 15 -1 -1 -1 -1 -3 -3 -3 -3 -16 -16 -16 -16 -17 -17 -17 -17 -18 -18 -18 -18 15 15 15 15 -1 -1 -1 -1 

[test]
name: rotate short8
kernel_name: test_8_rotate_short
global_size: 13 0 0

arg_out: 0 buffer short[104] 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 8192 8192 8192 8192 8192 8192 8192 8192 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 16384 16384 16384 16384 16384 16384 16384 16384 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767  tolerance 0 
arg_in: 1 buffer short[104] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2 -2 -2 -2 -2 -2 -2 -2 
arg_in: 2 buffer short[104] 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 16 16 16 16 16 16 16 16 17 17 17 17 17 17 17 17 160 160 160 160 160 160 160 160 15 15 15 15 15 15 15 15 -1 -1 -1 -1 -1 -1 -1 -1 -3 -3 -3 -3 -3 -3 -3 -3 -16 -16 -16 -16 -16 -16 -16 -16 -17 -17 -17 -17 -17 -17 -17 -17 -18 -18 -18 -18 -18 -18 -18 -18 15 15 15 15 15 15 15 15 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: rotate short16
kernel_name: test_16_rotate_short
global_size: 13 0 0

arg_out: 0 buffer short[208] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 8192 8192 8192 8192 8192 8192 8192 8192 8192 8192 8192 8192 8192 8192 8192 8192 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767  tolerance 0 
arg_in: 1 buffer short[208] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 -2 
arg_in: 2 buffer short[208] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 17 160 160 160 160 160 160 160 160 160 160 160 160 160 160 160 160 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -3 -16 -16 -16 -16 -16 -16 -16 -16 -16 -16 -16 -16 -16 -16 -16 -16 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -17 -18 -18 -18 -18 -18 -18 -18 -18 -18 -18 -18 -18 -18 -18 -18 -18 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 

!*/

kernel void test_1_rotate_short(global short* out, global short* in0, global short* in1){
  out[get_global_id(0)] = rotate(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_rotate_short(global short* out, global short* in0, global short* in1){
  vstore2(rotate(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_rotate_short(global short* out, global short* in0, global short* in1){
  vstore4(rotate(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_rotate_short(global short* out, global short* in0, global short* in1){
  vstore8(rotate(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_rotate_short(global short* out, global short* in0, global short* in1){
  vstore16(rotate(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

