/*!
[config]
name: Test short popcount built-in on CL 1.1
clc_version_min: 12
dimensions: 1

[test]
name: popcount short1
kernel_name: test_1_popcount_short
global_size: 5 0 0

arg_out: 0 buffer short[5] 1 2 0 15 1  tolerance 0 
arg_in: 1 buffer short[5] 1 3 0 32767 -32768 

[test]
name: popcount short2
kernel_name: test_2_popcount_short
global_size: 5 0 0

arg_out: 0 buffer short[10] 1 1 2 2 0 0 15 15 1 1  tolerance 0 
arg_in: 1 buffer short[10] 1 1 3 3 0 0 32767 32767 -32768 -32768 

[test]
name: popcount short4
kernel_name: test_4_popcount_short
global_size: 5 0 0

arg_out: 0 buffer short[20] 1 1 1 1 2 2 2 2 0 0 0 0 15 15 15 15 1 1 1 1  tolerance 0 
arg_in: 1 buffer short[20] 1 1 1 1 3 3 3 3 0 0 0 0 32767 32767 32767 32767 -32768 -32768 -32768 -32768 

[test]
name: popcount short8
kernel_name: test_8_popcount_short
global_size: 5 0 0

arg_out: 0 buffer short[40] 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 15 15 15 15 15 15 15 15 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer short[40] 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 

[test]
name: popcount short16
kernel_name: test_16_popcount_short
global_size: 5 0 0

arg_out: 0 buffer short[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer short[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 

!*/

kernel void test_1_popcount_short(global short* out, global short* in0){
  out[get_global_id(0)] = popcount(in0[get_global_id(0)]);
}

kernel void test_2_popcount_short(global short* out, global short* in0){
  vstore2(popcount(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_popcount_short(global short* out, global short* in0){
  vstore4(popcount(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_popcount_short(global short* out, global short* in0){
  vstore8(popcount(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_popcount_short(global short* out, global short* in0){
  vstore16(popcount(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

