/*!
[config]
name: Test short mul_hi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: mul_hi short1
kernel_name: test_1_mul_hi_short
global_size: 12 0 0

arg_out: 0 buffer short[12] 0 0 0 16383 16384 0 0 -16384 0 -1 -1 -1  tolerance 0 
arg_in: 1 buffer short[12] 0 92 32767 32767 -32768 92 32767 -32768 -1 -32768 -32768 1 
arg_in: 2 buffer short[12] 0 2 1 32767 -32768 1 2 32767 -32768 2 1 -1 

[test]
name: mul_hi short2
kernel_name: test_2_mul_hi_short
global_size: 12 0 0

arg_out: 0 buffer short[24] 0 0 0 0 0 0 16383 16383 16384 16384 0 0 0 0 -16384 -16384 0 0 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer short[24] 0 0 92 92 32767 32767 32767 32767 -32768 -32768 92 92 32767 32767 -32768 -32768 -1 -1 -32768 -32768 -32768 -32768 1 1 
arg_in: 2 buffer short[24] 0 0 2 2 1 1 32767 32767 -32768 -32768 1 1 2 2 32767 32767 -32768 -32768 2 2 1 1 -1 -1 

[test]
name: mul_hi short4
kernel_name: test_4_mul_hi_short
global_size: 12 0 0

arg_out: 0 buffer short[48] 0 0 0 0 0 0 0 0 0 0 0 0 16383 16383 16383 16383 16384 16384 16384 16384 0 0 0 0 0 0 0 0 -16384 -16384 -16384 -16384 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer short[48] 0 0 0 0 92 92 92 92 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 92 92 92 92 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 1 1 1 1 
arg_in: 2 buffer short[48] 0 0 0 0 2 2 2 2 1 1 1 1 32767 32767 32767 32767 -32768 -32768 -32768 -32768 1 1 1 1 2 2 2 2 32767 32767 32767 32767 -32768 -32768 -32768 -32768 2 2 2 2 1 1 1 1 -1 -1 -1 -1 

[test]
name: mul_hi short8
kernel_name: test_8_mul_hi_short
global_size: 12 0 0

arg_out: 0 buffer short[96] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 16383 16383 16383 16383 16383 16383 16383 16383 16384 16384 16384 16384 16384 16384 16384 16384 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer short[96] 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 92 92 92 92 92 92 92 92 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 1 1 1 1 1 1 1 1 
arg_in: 2 buffer short[96] 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: mul_hi short16
kernel_name: test_16_mul_hi_short
global_size: 12 0 0

arg_out: 0 buffer short[192] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 16383 16383 16383 16383 16383 16383 16383 16383 16383 16383 16383 16383 16383 16383 16383 16383 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 16384 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 -16384 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer short[192] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer short[192] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 

!*/

kernel void test_1_mul_hi_short(global short* out, global short* in0, global short* in1){
  out[get_global_id(0)] = mul_hi(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_mul_hi_short(global short* out, global short* in0, global short* in1){
  vstore2(mul_hi(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_mul_hi_short(global short* out, global short* in0, global short* in1){
  vstore4(mul_hi(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_mul_hi_short(global short* out, global short* in0, global short* in1){
  vstore8(mul_hi(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_mul_hi_short(global short* out, global short* in0, global short* in1){
  vstore16(mul_hi(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

