/*!
[config]
name: Test short min built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: min short1
kernel_name: test_1_min_short
global_size: 14 0 0

arg_out: 0 buffer short[14] 2 1 -32768 4 1 -32768 32767 -32768 -32768 0 32767 -32768 -1 -32768  tolerance 0 
arg_in: 1 buffer short[14] 92 64 2 12 32767 -32768 32767 -32768 -32768 0 32767 -1 1 -32768 
arg_in: 2 buffer short[14] 2 1 -32768 4 1 1 32767 -32768 32767 0 32767 -32768 -1 -1 

[test]
name: min short2
kernel_name: test_2_min_short
global_size: 14 0 0

arg_out: 0 buffer short[28] 2 2 1 1 -32768 -32768 4 4 1 1 -32768 -32768 32767 32767 -32768 -32768 -32768 -32768 0 0 32767 32767 -32768 -32768 -1 -1 -32768 -32768  tolerance 0 
arg_in: 1 buffer short[28] 92 92 64 64 2 2 12 12 32767 32767 -32768 -32768 32767 32767 -32768 -32768 -32768 -32768 0 0 32767 32767 -1 -1 1 1 -32768 -32768 
arg_in: 2 buffer short[28] 2 2 1 1 -32768 -32768 4 4 1 1 1 1 32767 32767 -32768 -32768 32767 32767 0 0 32767 32767 -32768 -32768 -1 -1 -1 -1 

[test]
name: tss_min short2
kernel_name: test_tss_2_min_short
global_size: 14 0 0

arg_out: 0 buffer short[28] 2 2 1 1 -32768 -32768 4 4 1 1 -32768 -32768 32767 32767 -32768 -32768 -32768 -32768 0 0 32767 32767 -32768 -32768 -1 -1 -32768 -32768  tolerance 0 
arg_in: 1 buffer short[28] 92 92 64 64 2 2 12 12 32767 32767 -32768 -32768 32767 32767 -32768 -32768 -32768 -32768 0 0 32767 32767 -1 -1 1 1 -32768 -32768 
arg_in: 2 buffer short[14] 2 1 -32768 4 1 1 32767 -32768 32767 0 32767 -32768 -1 -1

[test]
name: min short4
kernel_name: test_4_min_short
global_size: 14 0 0

arg_out: 0 buffer short[56] 2 2 2 2 1 1 1 1 -32768 -32768 -32768 -32768 4 4 4 4 1 1 1 1 -32768 -32768 -32768 -32768 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -32768 -32768 -32768 -32768  tolerance 0 
arg_in: 1 buffer short[56] 92 92 92 92 64 64 64 64 2 2 2 2 12 12 12 12 32767 32767 32767 32767 -32768 -32768 -32768 -32768 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 32767 32767 32767 32767 -1 -1 -1 -1 1 1 1 1 -32768 -32768 -32768 -32768 
arg_in: 2 buffer short[56] 2 2 2 2 1 1 1 1 -32768 -32768 -32768 -32768 4 4 4 4 1 1 1 1 1 1 1 1 32767 32767 32767 32767 -32768 -32768 -32768 -32768 32767 32767 32767 32767 0 0 0 0 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: tss_min short4
kernel_name: test_tss_4_min_short
global_size: 14 0 0

arg_out: 0 buffer short[56] 2 2 2 2 1 1 1 1 -32768 -32768 -32768 -32768 4 4 4 4 1 1 1 1 -32768 -32768 -32768 -32768 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -32768 -32768 -32768 -32768  tolerance 0 
arg_in: 1 buffer short[56] 92 92 92 92 64 64 64 64 2 2 2 2 12 12 12 12 32767 32767 32767 32767 -32768 -32768 -32768 -32768 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 32767 32767 32767 32767 -1 -1 -1 -1 1 1 1 1 -32768 -32768 -32768 -32768 
arg_in: 2 buffer short[14] 2 1 -32768 4 1 1 32767 -32768 32767 0 32767 -32768 -1 -1

[test]
name: min short8
kernel_name: test_8_min_short
global_size: 14 0 0

arg_out: 0 buffer short[112] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768  tolerance 0 
arg_in: 1 buffer short[112] 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 
arg_in: 2 buffer short[112] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: tss_min short8
kernel_name: test_tss_8_min_short
global_size: 14 0 0

arg_out: 0 buffer short[112] 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768  tolerance 0 
arg_in: 1 buffer short[112] 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 
arg_in: 2 buffer short[14] 2 1 -32768 4 1 1 32767 -32768 32767 0 32767 -32768 -1 -1

[test]
name: min short16
kernel_name: test_16_min_short
global_size: 14 0 0

arg_out: 0 buffer short[224] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768  tolerance 0 
arg_in: 1 buffer short[224] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 
arg_in: 2 buffer short[224] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: tss_min short16
kernel_name: test_tss_16_min_short
global_size: 14 0 0

arg_out: 0 buffer short[224] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768  tolerance 0 
arg_in: 1 buffer short[224] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 
arg_in: 2 buffer short[14] 2 1 -32768 4 1 1 32767 -32768 32767 0 32767 -32768 -1 -1

!*/

kernel void test_1_min_short(global short* out, global short* in0, global short* in1){
  out[get_global_id(0)] = min(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_min_short(global short* out, global short* in0, global short* in1){
  vstore2(min(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_min_short(global short* out, global short* in0, global short* in1){
  vstore4(min(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_min_short(global short* out, global short* in0, global short* in1){
  vstore8(min(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_min_short(global short* out, global short* in0, global short* in1){
  vstore16(min(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_min_short(global short* out, global short* in0, global short* in1){
  vstore2(min(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_min_short(global short* out, global short* in0, global short* in1){
  vstore4(min(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_min_short(global short* out, global short* in0, global short* in1){
  vstore8(min(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_min_short(global short* out, global short* in0, global short* in1){
  vstore16(min(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

