/*!
[config]
name: Test short max built-in on CL 1.1
clc_version_min: 11
dimensions: 1

[test]
name: max short1
kernel_name: test_1_max_short
global_size: 12 0 0

arg_out: 0 buffer short[12] 92 2 12 32767 1 32767 -32768 32767 32767 0 -1 1  tolerance 0 
arg_in: 1 buffer short[12] 92 2 12 32767 -32768 32767 -32768 -32768 32767 0 -1 1 
arg_in: 2 buffer short[12] 2 -32768 4 1 1 32767 -32768 32767 -32768 0 -32768 -1 

[test]
name: max short2
kernel_name: test_2_max_short
global_size: 12 0 0

arg_out: 0 buffer short[24] 92 92 2 2 12 12 32767 32767 1 1 32767 32767 -32768 -32768 32767 32767 32767 32767 0 0 -1 -1 1 1  tolerance 0 
arg_in: 1 buffer short[24] 92 92 2 2 12 12 32767 32767 -32768 -32768 32767 32767 -32768 -32768 -32768 -32768 32767 32767 0 0 -1 -1 1 1 
arg_in: 2 buffer short[24] 2 2 -32768 -32768 4 4 1 1 1 1 32767 32767 -32768 -32768 32767 32767 -32768 -32768 0 0 -32768 -32768 -1 -1 

[test]
name: tss_max short2
kernel_name: test_tss_2_max_short
global_size: 12 0 0

arg_out: 0 buffer short[24] 92 92 2 2 12 12 32767 32767 1 1 32767 32767 -32768 -32768 32767 32767 32767 32767 0 0 -1 -1 1 1  tolerance 0 
arg_in: 1 buffer short[24] 92 92 2 2 12 12 32767 32767 -32768 -32768 32767 32767 -32768 -32768 -32768 -32768 32767 32767 0 0 -1 -1 1 1 
arg_in: 2 buffer short[12] 2 -32768 4 1 1 32767 -32768 32767 -32768 0 -32768 -1

[test]
name: max short4
kernel_name: test_4_max_short
global_size: 12 0 0

arg_out: 0 buffer short[48] 92 92 92 92 2 2 2 2 12 12 12 12 32767 32767 32767 32767 1 1 1 1 32767 32767 32767 32767 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 -1 -1 -1 -1 1 1 1 1  tolerance 0 
arg_in: 1 buffer short[48] 92 92 92 92 2 2 2 2 12 12 12 12 32767 32767 32767 32767 -32768 -32768 -32768 -32768 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 0 0 0 0 -1 -1 -1 -1 1 1 1 1 
arg_in: 2 buffer short[48] 2 2 2 2 -32768 -32768 -32768 -32768 4 4 4 4 1 1 1 1 1 1 1 1 32767 32767 32767 32767 -32768 -32768 -32768 -32768 32767 32767 32767 32767 -32768 -32768 -32768 -32768 0 0 0 0 -32768 -32768 -32768 -32768 -1 -1 -1 -1 

[test]
name: tss_max short4
kernel_name: test_tss_4_max_short
global_size: 12 0 0

arg_out: 0 buffer short[48] 92 92 92 92 2 2 2 2 12 12 12 12 32767 32767 32767 32767 1 1 1 1 32767 32767 32767 32767 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 -1 -1 -1 -1 1 1 1 1  tolerance 0 
arg_in: 1 buffer short[48] 92 92 92 92 2 2 2 2 12 12 12 12 32767 32767 32767 32767 -32768 -32768 -32768 -32768 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 0 0 0 0 -1 -1 -1 -1 1 1 1 1 
arg_in: 2 buffer short[12] 2 -32768 4 1 1 32767 -32768 32767 -32768 0 -32768 -1

[test]
name: max short8
kernel_name: test_8_max_short
global_size: 12 0 0

arg_out: 0 buffer short[96] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer short[96] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer short[96] 2 2 2 2 2 2 2 2 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 0 0 0 0 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: tss_max short8
kernel_name: test_tss_8_max_short
global_size: 12 0 0

arg_out: 0 buffer short[96] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer short[96] 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer short[12] 2 -32768 4 1 1 32767 -32768 32767 -32768 0 -32768 -1

[test]
name: max short16
kernel_name: test_16_max_short
global_size: 12 0 0

arg_out: 0 buffer short[192] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer short[192] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer short[192] 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 

[test]
name: tss_max short16
kernel_name: test_tss_16_max_short
global_size: 12 0 0

arg_out: 0 buffer short[192] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1  tolerance 0 
arg_in: 1 buffer short[192] 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 92 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
arg_in: 2 buffer short[12] 2 -32768 4 1 1 32767 -32768 32767 -32768 0 -32768 -1

!*/

kernel void test_1_max_short(global short* out, global short* in0, global short* in1){
  out[get_global_id(0)] = max(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_max_short(global short* out, global short* in0, global short* in1){
  vstore2(max(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_max_short(global short* out, global short* in0, global short* in1){
  vstore4(max(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_max_short(global short* out, global short* in0, global short* in1){
  vstore8(max(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_max_short(global short* out, global short* in0, global short* in1){
  vstore16(max(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_tss_2_max_short(global short* out, global short* in0, global short* in1){
  vstore2(max(vload2(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_4_max_short(global short* out, global short* in0, global short* in1){
  vstore4(max(vload4(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_8_max_short(global short* out, global short* in0, global short* in1){
  vstore8(max(vload8(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

kernel void test_tss_16_max_short(global short* out, global short* in0, global short* in1){
  vstore16(max(vload16(get_global_id(0), in0), in1[get_global_id(0)]), get_global_id(0), out);
}

