/*!
[config]
name: Test short hadd built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: hadd short1
kernel_name: test_1_hadd_short
global_size: 7 0 0

arg_out: 0 buffer short[7] 32 0 10 32767 -32768 -1 -1  tolerance 0 
arg_in: 1 buffer short[7] 32 1 12 32767 -32768 32767 -32768 
arg_in: 2 buffer short[7] 33 0 8 32767 -32768 -32768 32767 

[test]
name: hadd short2
kernel_name: test_2_hadd_short
global_size: 7 0 0

arg_out: 0 buffer short[14] 32 32 0 0 10 10 32767 32767 -32768 -32768 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer short[14] 32 32 1 1 12 12 32767 32767 -32768 -32768 32767 32767 -32768 -32768 
arg_in: 2 buffer short[14] 33 33 0 0 8 8 32767 32767 -32768 -32768 -32768 -32768 32767 32767 

[test]
name: hadd short4
kernel_name: test_4_hadd_short
global_size: 7 0 0

arg_out: 0 buffer short[28] 32 32 32 32 0 0 0 0 10 10 10 10 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer short[28] 32 32 32 32 1 1 1 1 12 12 12 12 32767 32767 32767 32767 -32768 -32768 -32768 -32768 32767 32767 32767 32767 -32768 -32768 -32768 -32768 
arg_in: 2 buffer short[28] 33 33 33 33 0 0 0 0 8 8 8 8 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 

[test]
name: hadd short8
kernel_name: test_8_hadd_short
global_size: 7 0 0

arg_out: 0 buffer short[56] 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 10 10 10 10 10 10 10 10 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer short[56] 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 
arg_in: 2 buffer short[56] 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 

[test]
name: hadd short16
kernel_name: test_16_hadd_short
global_size: 7 0 0

arg_out: 0 buffer short[112] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer short[112] 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 
arg_in: 2 buffer short[112] 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 33 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 

!*/

kernel void test_1_hadd_short(global short* out, global short* in0, global short* in1){
  out[get_global_id(0)] = hadd(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_hadd_short(global short* out, global short* in0, global short* in1){
  vstore2(hadd(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_hadd_short(global short* out, global short* in0, global short* in1){
  vstore4(hadd(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_hadd_short(global short* out, global short* in0, global short* in1){
  vstore8(hadd(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_hadd_short(global short* out, global short* in0, global short* in1){
  vstore16(hadd(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

