/*!
[config]
name: Test short clz built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: clz short1
kernel_name: test_1_clz_short
global_size: 5 0 0

arg_out: 0 buffer short[5] 15 9 16 1 0  tolerance 0 
arg_in: 1 buffer short[5] 1 64 0 32767 -32768 

[test]
name: clz short2
kernel_name: test_2_clz_short
global_size: 5 0 0

arg_out: 0 buffer short[10] 15 15 9 9 16 16 1 1 0 0  tolerance 0 
arg_in: 1 buffer short[10] 1 1 64 64 0 0 32767 32767 -32768 -32768 

[test]
name: clz short4
kernel_name: test_4_clz_short
global_size: 5 0 0

arg_out: 0 buffer short[20] 15 15 15 15 9 9 9 9 16 16 16 16 1 1 1 1 0 0 0 0  tolerance 0 
arg_in: 1 buffer short[20] 1 1 1 1 64 64 64 64 0 0 0 0 32767 32767 32767 32767 -32768 -32768 -32768 -32768 

[test]
name: clz short8
kernel_name: test_8_clz_short
global_size: 5 0 0

arg_out: 0 buffer short[40] 15 15 15 15 15 15 15 15 9 9 9 9 9 9 9 9 16 16 16 16 16 16 16 16 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer short[40] 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 

[test]
name: clz short16
kernel_name: test_16_clz_short
global_size: 5 0 0

arg_out: 0 buffer short[80] 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer short[80] 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 32767 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 -32768 

!*/

kernel void test_1_clz_short(global short* out, global short* in0){
  out[get_global_id(0)] = clz(in0[get_global_id(0)]);
}

kernel void test_2_clz_short(global short* out, global short* in0){
  vstore2(clz(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_clz_short(global short* out, global short* in0){
  vstore4(clz(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_clz_short(global short* out, global short* in0){
  vstore8(clz(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_clz_short(global short* out, global short* in0){
  vstore16(clz(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

